/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.SourceType;
import jp.vmi.selenium.selenese.TestProjectParser;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.Binder;
import jp.vmi.selenium.selenese.parser.AbstractTestElementIterator;
import jp.vmi.selenium.selenese.parser.ParserUtils;
import jp.vmi.selenium.selenese.parser.SeleneseTestSuiteIterator;
import jp.vmi.selenium.selenese.parser.SideTestSuiteIterator;

public abstract class Parser {
    public static Selenese parse(String filename, InputStream is, ICommandFactory commandFactory) {
        boolean isSide = filename.toLowerCase().endsWith(".side");
        try {
            AbstractTestElementIterator iter;
            SourceType sourceType;
            if (isSide) {
                sourceType = SourceType.SIDE;
                iter = new SideTestSuiteIterator(filename, is);
            } else {
                sourceType = SourceType.SELENESE;
                iter = new SeleneseTestSuiteIterator(filename, is);
            }
            return TestProjectParser.parse(sourceType, iter, commandFactory);
        }
        catch (InvalidSeleneseException e) {
            return isSide ? Binder.newErrorTestProject(filename, e) : Binder.newErrorTestSuite(filename, e);
        }
    }

    public static Selenese parse(String filename, ICommandFactory commandFactory) {
        Selenese selenese;
        FileInputStream is = new FileInputStream(filename);
        try {
            selenese = Parser.parse(filename, is, commandFactory);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String name = ParserUtils.getNameFromFilename(filename);
                return Binder.newErrorTestSuite(filename, new InvalidSeleneseException(e.getMessage(), filename, name));
            }
        }
        ((InputStream)is).close();
        return selenese;
    }

    protected abstract Selenese parse(ICommandFactory var1);
}

