/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import jp.vmi.selenium.selenese.Context;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifierKeyState {
    private static final Logger log = LoggerFactory.getLogger(ModifierKeyState.class);
    private final Context context;
    private boolean metaKeyDown = false;
    private boolean altKeyDown = false;
    private boolean controlKeyDown = false;
    private boolean shiftKeyDown = false;

    public ModifierKeyState(Context context) {
        this.context = context;
    }

    private Actions newActions() {
        return new Actions(this.context.getWrappedDriver());
    }

    public void reset() {
        Actions actions = this.newActions();
        boolean perform = false;
        StringBuilder buf = new StringBuilder(4);
        if (this.metaKeyDown) {
            actions.keyUp((CharSequence)Keys.META);
            this.metaKeyDown = false;
            perform = true;
            buf.append('M');
        }
        if (this.altKeyDown) {
            actions.keyUp((CharSequence)Keys.ALT);
            this.altKeyDown = false;
            perform = true;
            buf.append('A');
        }
        if (this.controlKeyDown) {
            actions.keyUp((CharSequence)Keys.CONTROL);
            this.controlKeyDown = false;
            perform = true;
            buf.append('C');
        }
        if (this.shiftKeyDown) {
            actions.keyUp((CharSequence)Keys.SHIFT);
            this.shiftKeyDown = false;
            perform = true;
            buf.append('S');
        }
        if (perform) {
            actions.build().perform();
            log.debug("Reset modifier keys: {}", (Object)buf);
        }
    }

    public boolean isMetaKeyDown() {
        return this.metaKeyDown;
    }

    public void metaKeyDown() {
        if (this.metaKeyDown) {
            return;
        }
        this.newActions().keyDown((CharSequence)Keys.META).perform();
        this.metaKeyDown = true;
        log.debug("Meta key down: {}", (Object)this.getStateString());
    }

    public void metaKeyUp() {
        if (!this.metaKeyDown) {
            return;
        }
        this.newActions().keyUp((CharSequence)Keys.META).perform();
        this.metaKeyDown = false;
        log.debug("Meta key up: {}", (Object)this.getStateString());
    }

    public boolean isAltKeyDown() {
        return this.altKeyDown;
    }

    public void altKeyDown() {
        if (this.altKeyDown) {
            return;
        }
        this.newActions().keyDown((CharSequence)Keys.ALT).perform();
        this.altKeyDown = true;
        log.debug("Alt key down: {}", (Object)this.getStateString());
    }

    public void altKeyUp() {
        if (!this.altKeyDown) {
            return;
        }
        this.newActions().keyUp((CharSequence)Keys.ALT).perform();
        this.altKeyDown = false;
        log.debug("Alt key up: {}", (Object)this.getStateString());
    }

    public boolean isControlKeyDown() {
        return this.controlKeyDown;
    }

    public void controlKeyDown() {
        if (this.controlKeyDown) {
            return;
        }
        this.newActions().keyDown((CharSequence)Keys.CONTROL).perform();
        this.controlKeyDown = true;
        log.debug("Control key down: {}", (Object)this.getStateString());
    }

    public void controlKeyUp() {
        if (!this.controlKeyDown) {
            return;
        }
        this.newActions().keyUp((CharSequence)Keys.CONTROL).perform();
        this.controlKeyDown = false;
        log.debug("Control key up: {}", (Object)this.getStateString());
    }

    public boolean isShiftKeyDown() {
        return this.shiftKeyDown;
    }

    public void shiftKeyDown() {
        if (this.shiftKeyDown) {
            return;
        }
        this.newActions().keyDown((CharSequence)Keys.SHIFT).perform();
        this.shiftKeyDown = true;
        log.debug("Shift key down: {}", (Object)this.getStateString());
    }

    public void shiftKeyUp() {
        if (!this.shiftKeyDown) {
            return;
        }
        this.newActions().keyUp((CharSequence)Keys.SHIFT).perform();
        this.shiftKeyDown = false;
        log.debug("Shift key up: {}", (Object)this.getStateString());
    }

    public String getStateString() {
        StringBuilder buf = new StringBuilder(4);
        if (this.metaKeyDown) {
            buf.append('M');
        }
        if (this.altKeyDown) {
            buf.append('A');
        }
        if (this.controlKeyDown) {
            buf.append('C');
        }
        if (this.shiftKeyDown) {
            buf.append('S');
        }
        return buf.toString();
    }
}

