/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.runner.model.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import jp.vmi.selenium.selenese.utils.EscapeUtils;

public class CommandsJs {
    private final Map<String, String> targetTypes = new LinkedHashMap<String, String>();
    private final Map<String, Map<String, String>> commands = new LinkedHashMap<String, Map<String, String>>();
    private static final String COMMANDS_JS = "/selenium-ide/Commands.js";

    private CommandsJs() {
    }

    public Map<String, String> getTargetTypes() {
        return this.targetTypes;
    }

    public Map<String, Map<String, String>> getCommands() {
        return this.commands;
    }

    public static CommandsJs load() {
        Parser parser = new Parser();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(CommandsJs.class.getResourceAsStream(COMMANDS_JS), StandardCharsets.UTF_8));){
            r.lines().forEach(x$0 -> parser.parseLine(x$0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CommandsJs commandJs = new CommandsJs();
        parser.getTargetTypes().forEach((key, value) -> {
            if (value instanceof Number && ((Number)value).intValue() == 0) {
                commandJs.targetTypes.put((String)key, "");
            } else {
                commandJs.targetTypes.put((String)key, (String)value);
            }
        });
        parser.getCommands().forEach(item -> {
            String key = (String)item.get(0);
            Map value = (Map)item.get(1);
            switch (key) {
                case "assertConfirmation": 
                case "assertPrompt": {
                    if (value.containsKey("target")) break;
                    value.put("target", "ArgTypes.alertText");
                    break;
                }
                case "storeTitle": {
                    if (value.containsKey("value")) break;
                    value.put("value", "ArgTypes.variableName");
                }
            }
            commandJs.commands.put(key, value);
        });
        return commandJs;
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }

    private static class Parser {
        private State state = State.TOP_LEVEL;
        private final Lines targetTypes = new Lines();
        private final Lines commands = new Lines();

        private Parser() {
        }

        private void parseLine(String line) {
            this.state = (State)((Object)this.state.processor.apply(this, line));
        }

        private Map<String, Object> getTargetTypes() {
            String json = this.targetTypes.toString();
            return (Map)new Gson().fromJson(json, Map.class);
        }

        private List<List<Object>> getCommands() {
            String json = this.commands.toString();
            return (List)new Gson().fromJson(json, List.class);
        }
    }

    private static class Lines {
        private final StringBuilder body = new StringBuilder();
        private boolean isInMLStr = false;

        private Lines() {
        }

        private void append(String s) {
            this.body.append(this.isInMLStr ? EscapeUtils.escapeJSString(s) : s);
        }

        public Lines add(String line) {
            int bqIndex;
            if (this.body.length() > 0) {
                this.body.append(' ');
            }
            if ((bqIndex = (line = line.trim()).indexOf(96)) < 0) {
                this.append(line);
                return this;
            }
            int offset = 0;
            do {
                if (offset < bqIndex) {
                    String ss = line.substring(offset, bqIndex);
                    this.append(ss);
                }
                this.body.append('\"');
                boolean bl = this.isInMLStr = !this.isInMLStr;
            } while ((bqIndex = line.indexOf(96, offset = bqIndex + 1)) >= 0);
            if (offset < line.length()) {
                this.append(line.substring(offset));
            }
            return this;
        }

        public Lines removeTrailingComma() {
            int tail = this.body.length() - 1;
            if (tail >= 0 && this.body.charAt(tail) == ',') {
                this.body.deleteCharAt(tail);
            }
            return this;
        }

        public String toString() {
            return this.body.toString();
        }
    }

    private static enum State {
        TOP_LEVEL(State::processTopLevel),
        TARGET_TYPES(State::processTargetTypes),
        COMMANDS(State::processCommands);

        private final BiFunction<Parser, String, State> processor;

        private static State processTopLevel(Parser parser, String line) {
            if (line.matches("export\\s+const\\s+TargetTypes\\s+=\\s+\\{\\s*")) {
                parser.targetTypes.add("{");
                return TARGET_TYPES;
            }
            if (line.matches("export\\s+const\\s+Commands\\s*=\\s*\\[\\s*")) {
                parser.commands.add("[");
                return COMMANDS;
            }
            return TOP_LEVEL;
        }

        private static State processTargetTypes(Parser parser, String line) {
            if (line.matches("\\}\\s*")) {
                parser.targetTypes.removeTrailingComma().add("}");
                return TOP_LEVEL;
            }
            parser.targetTypes.add(line);
            return TARGET_TYPES;
        }

        private static State processCommands(Parser parser, String line) {
            if (line.matches("\\]\\s*")) {
                parser.commands.removeTrailingComma().add("]");
                return TOP_LEVEL;
            }
            if (line.matches("\\s*[\\]\\}].*")) {
                parser.commands.removeTrailingComma();
            }
            parser.commands.add(line);
            return COMMANDS;
        }

        private State(BiFunction<Parser, String, State> processor) {
            this.processor = processor;
        }
    }
}

