/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.runner.model.side;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import jp.vmi.selenium.runner.model.side.SideBase;
import jp.vmi.selenium.runner.model.side.SideProject;
import jp.vmi.selenium.runner.model.side.SideSuite;
import jp.vmi.selenium.runner.model.side.SideTest;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.parser.ParserUtils;

public class SideFile
extends SideBase {
    private String url;
    private List<SideTest> tests = null;
    private List<SideSuite> suites = null;
    private List<Object> urls = null;

    public SideFile(boolean isGen) {
        super(isGen);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<SideTest> getTests() {
        return this.tests;
    }

    public void setTests(List<SideTest> tests) {
        this.tests = tests;
    }

    public void addTest(SideTest test) {
        if (this.tests == null) {
            this.tests = new ArrayList<SideTest>();
        }
        this.tests.add(test);
    }

    public List<SideSuite> getSuites() {
        return this.suites;
    }

    public void setSuites(List<SideSuite> suites) {
        this.suites = suites;
    }

    public void addSuite(SideSuite suite) {
        if (this.suites == null) {
            this.suites = new ArrayList<SideSuite>();
        }
        this.suites.add(suite);
    }

    public List<Object> getUrls() {
        return this.urls;
    }

    public void setUrls(List<Object> urls) {
        this.urls = urls;
    }

    private static <T> TypeAdapter<T> newSideSuiteAdapter(Gson gson) {
        return new TypeAdapter<SideSuite>(){

            public void write(JsonWriter out, SideSuite suite) throws IOException {
                out.beginObject();
                out.name("parallel");
                out.value(suite.isParallel());
                out.name("timeout");
                out.value((long)suite.getTimeout());
                out.name("tests");
                out.beginArray();
                for (SideTest test : suite.getTests()) {
                    out.value(test.getId());
                }
                out.endArray();
                out.name("id");
                out.value(suite.getId());
                out.name("name");
                out.value(suite.getName());
                out.endObject();
            }

            public SideSuite read(JsonReader in) throws IOException {
                SideSuite suite = new SideSuite(false);
                in.beginObject();
                block16: while (in.peek() != JsonToken.END_OBJECT) {
                    switch (in.nextName()) {
                        case "id": {
                            suite.setId(in.nextString());
                            continue block16;
                        }
                        case "name": {
                            suite.setName(in.nextString());
                            continue block16;
                        }
                        case "parallel": {
                            suite.setParallel(in.nextBoolean());
                            continue block16;
                        }
                        case "timeout": {
                            suite.setTimeout(in.nextInt());
                            continue block16;
                        }
                        case "persistSession": {
                            suite.setPersistSession(in.nextBoolean());
                            continue block16;
                        }
                        case "tests": {
                            in.beginArray();
                            ArrayList<SideTest> tests = new ArrayList<SideTest>();
                            while (in.peek() != JsonToken.END_ARRAY) {
                                SideTest test = new SideTest(false);
                                test.setId(in.nextString());
                                tests.add(test);
                            }
                            suite.setTests(tests);
                            in.endArray();
                            continue block16;
                        }
                    }
                    in.skipValue();
                }
                in.endObject();
                return suite;
            }
        };
    }

    private static Gson newGson() {
        return new GsonBuilder().registerTypeAdapterFactory(new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.getType() == SideSuite.class) {
                    return SideFile.newSideSuiteAdapter(gson);
                }
                return null;
            }
        }).create();
    }

    public static SideProject parse(String filename, InputStream is) throws InvalidSeleneseException {
        SideProject sideProject;
        InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);
        try {
            sideProject = new SideProject(filename, (SideFile)SideFile.newGson().fromJson((Reader)r, SideFile.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidSeleneseException(e, filename, ParserUtils.getNameFromFilename(filename));
            }
        }
        ((Reader)r).close();
        return sideProject;
    }
}

