/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.script;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSWrapper {
    private static final Logger log = LoggerFactory.getLogger(JSWrapper.class);
    public static final String OBJECT = "object";
    public static final String ARGS = "args";
    private final ScriptEngine engine;
    private final Object object;
    private final Bindings bindings;

    public JSWrapper(ScriptEngine engine, Object object) {
        this.engine = engine;
        this.object = object;
        this.bindings = engine.createBindings();
        this.bindings.put(OBJECT, object);
    }

    public <T> T eval(String script, Object ... args) {
        try {
            this.bindings.put(ARGS, (Object)args);
            return (T)this.engine.eval(script, this.bindings);
        }
        catch (ScriptException e) {
            log.info("Failed: [{}] - {}", (Object)script, (Object)e);
            return null;
        }
    }

    public Object unwrap() {
        return this.object;
    }
}

