/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.junit.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jp.vmi.junit.result.ITestSuite;
import jp.vmi.junit.result.ObjectFactory;
import jp.vmi.junit.result.Property;
import jp.vmi.junit.result.TestCaseResult;
import jp.vmi.junit.result.TestResult;

@XmlRootElement(name="testsuite")
@XmlType(propOrder={"properties", "error", "testCaseResults"})
public class TestSuiteResult
extends TestResult<ITestSuite> {
    @XmlAttribute
    private Integer id;
    @XmlAttribute
    private BigDecimal time;
    @XmlElementWrapper
    @XmlElement(name="property")
    private final List<Property> properties = new ArrayList<Property>();
    @XmlElement
    private TestCaseResult error;
    @XmlElement(name="testcase")
    private final List<TestCaseResult> testCaseResults = new ArrayList<TestCaseResult>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String name, String value) {
        Property property = ObjectFactory.factory.createProperty(name, value);
        List<Property> list = this.properties;
        synchronized (list) {
            this.properties.add(property);
        }
    }

    public void setError(TestCaseResult error) {
        this.error = error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTestCaseResult(TestCaseResult caseResult) {
        List<TestCaseResult> list = this.testCaseResults;
        synchronized (list) {
            this.testCaseResults.add(caseResult);
        }
    }

    @XmlAttribute
    public int getTests() {
        return this.testCaseResults.size();
    }

    @XmlAttribute
    public int getFailures() {
        int failures = 0;
        for (TestCaseResult caseResult : this.testCaseResults) {
            failures += caseResult.getFailures();
        }
        return failures;
    }

    @XmlAttribute
    public int getErrors() {
        int errors = 0;
        for (TestCaseResult caseResult : this.testCaseResults) {
            errors += caseResult.getErrors();
        }
        return errors;
    }

    @XmlAttribute
    public int getSkipped() {
        int skipped = 0;
        for (TestCaseResult caseResult : this.testCaseResults) {
            skipped += caseResult.getSkipped().intValue();
        }
        return skipped;
    }
}

