/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.html.result;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.vmi.html.result.TestSuiteSummary;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.TestSuite;

public class TestSuiteTree {
    private final Node root = new Node(null, null, null);
    private final Map<TestSuite, Node> map = new HashMap<TestSuite, Node>();

    public TestSuiteSummary getSummary(TestSuite testSuite) {
        Node node = this.map.get(testSuite);
        return node != null ? node.summary : null;
    }

    public void add(TestSuite testSuite, TestSuiteSummary summary) {
        Node node = new Node(this.root, testSuite, summary);
        for (Selenese selenese : testSuite.getSeleneseList()) {
            Node child = this.map.get(selenese);
            if (child == null) continue;
            child.parent.children.remove(child);
            child.parent = node;
            node.children.add(child);
        }
        this.root.children.add(node);
        this.map.put(testSuite, node);
    }

    public List<Node> getRootNodeList() {
        return this.root.children;
    }

    public static class Node {
        public Node parent = null;
        public final TestSuite testSuite;
        public final TestSuiteSummary summary;
        public final List<Node> children = new ArrayList<Node>();

        private Node(Node parent, TestSuite testSuite, TestSuiteSummary summary) {
            this.parent = parent;
            this.testSuite = testSuite;
            this.summary = summary;
        }
    }
}

