/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class SeleniumUtils {
    public static boolean patternMatches(String pattern, CharSequence input) {
        return new SeleniumPattern(pattern).matches(input.toString());
    }

    public static <T> String convertToString(T result) {
        if (result == null) {
            return "";
        }
        if (result instanceof Object[]) {
            return StringUtils.join((Object[])((Object[])result), (char)',');
        }
        if (result instanceof Iterable) {
            return StringUtils.join((Iterable)((Iterable)result), (char)',');
        }
        if (result instanceof Iterator) {
            return StringUtils.join((Iterator)((Iterator)result), (char)',');
        }
        return result.toString();
    }

    public static boolean isJava7orLater() {
        String[] version = SystemUtils.JAVA_VERSION.split("[._]");
        int major = NumberUtils.toInt((String)version[0]);
        if (version.length < 2 || major == 0) {
            throw new UnsupportedOperationException("Can't parse Java version string: " + SystemUtils.JAVA_VERSION);
        }
        return major >= 2 || NumberUtils.toInt((String)version[1]) >= 7;
    }

    public static class SeleniumPattern {
        public final Type type;
        public final Pattern regexpPattern;
        public final String stringPattern;

        public SeleniumPattern(String pattern) {
            String[] p = pattern.split(":", 2);
            if (p.length == 2) {
                String type = p[0].toLowerCase();
                if ("regexp".equals(type)) {
                    this.type = Type.REGEXP;
                    this.regexpPattern = Pattern.compile(p[1]);
                    this.stringPattern = p[1];
                    return;
                }
                if ("regexpi".equals(type)) {
                    this.type = Type.REGEXPI;
                    this.regexpPattern = Pattern.compile(p[1], 2);
                    this.stringPattern = p[1];
                    return;
                }
                if ("glob".equals(type)) {
                    pattern = p[1];
                } else if ("exact".equals(type)) {
                    this.type = Type.EXACT;
                    this.regexpPattern = null;
                    this.stringPattern = p[1];
                    return;
                }
            }
            if (pattern.indexOf(42) >= 0 || pattern.indexOf(63) >= 0) {
                int len;
                this.type = Type.GLOB;
                StringBuilder re = new StringBuilder("\\A\\Q");
                re.append(pattern.replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q"));
                if (re.length() >= 6 && re.charAt(4) == '\\' && re.charAt(5) == 'E') {
                    re.delete(2, 6);
                }
                if (re.charAt((len = re.length()) - 2) == '\\' && re.charAt(len - 1) == 'Q') {
                    re.setCharAt(re.length() - 1, 'z');
                } else {
                    re.append("\\E\\z");
                }
                this.regexpPattern = Pattern.compile(re.toString(), 32);
            } else {
                this.type = Type.EXACT;
                this.regexpPattern = null;
            }
            this.stringPattern = pattern;
        }

        public boolean matches(String input) {
            switch (this.type) {
                case REGEXP: 
                case REGEXPI: 
                case GLOB: {
                    return this.regexpPattern.matcher(input).find();
                }
                case EXACT: {
                    return this.stringPattern.equals(input);
                }
            }
            throw new UnsupportedOperationException(this.type.toString());
        }

        public String toString() {
            return "SeleniumPattern[" + (Object)((Object)this.type) + ":" + this.stringPattern + "]";
        }

        public static enum Type {
            REGEXP,
            REGEXPI,
            GLOB,
            EXACT;

        }
    }
}

