/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.inject;

import jp.vmi.html.result.HtmlResult;
import jp.vmi.html.result.HtmlResultHolder;
import jp.vmi.junit.result.JUnitResult;
import jp.vmi.junit.result.JUnitResultHolder;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.TestSuite;
import jp.vmi.selenium.selenese.utils.LogRecorder;
import jp.vmi.selenium.selenese.utils.StopWatch;
import jp.vmi.selenium.selenese.utils.SystemInformation;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTestSuiteInterceptor
implements MethodInterceptor {
    private static final int PARENT = 0;
    private static final int CONTEXT = 1;
    private static final Logger log = LoggerFactory.getLogger(ExecuteTestSuiteInterceptor.class);

    private void initTestSuiteResult(JUnitResult jUnitResult, TestSuite testSuite) {
        jUnitResult.startTestSuite(testSuite);
        SystemInformation sysInfo = SystemInformation.getInstance();
        jUnitResult.addProperty(testSuite, "seleneseRunner.version", sysInfo.getSeleneseRunnerVersion());
        jUnitResult.addProperty(testSuite, "selenium.version", sysInfo.getSeleniumVersion());
        jUnitResult.addProperty(testSuite, "selenium.webDriver.name", testSuite.getWebDriverName());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object msg;
        TestSuite testSuite = (TestSuite)invocation.getThis();
        Context context = (Context)invocation.getArguments()[1];
        testSuite.setWebDriverName(context.getWrappedDriver().getClass().getSimpleName());
        JUnitResult jUnitResult = context instanceof JUnitResultHolder ? ((JUnitResultHolder)((Object)context)).getJUnitResult() : null;
        HtmlResult htmlResult = context instanceof HtmlResultHolder ? ((HtmlResultHolder)((Object)context)).getHtmlResult() : null;
        StopWatch sw = testSuite.getStopWatch();
        LogRecorder slr = new LogRecorder(context.getPrintStream());
        sw.start();
        if (!testSuite.isError()) {
            msg = "Start: " + testSuite;
            log.info((String)msg);
            slr.info((String)msg);
        }
        this.initTestSuiteResult(jUnitResult, testSuite);
        try {
            msg = invocation.proceed();
            return msg;
        }
        catch (Throwable t) {
            String msg2 = t.getMessage();
            log.error(msg2);
            slr.error(msg2);
            throw t;
        }
        finally {
            if (!testSuite.isError()) {
                String msg3 = "End(" + sw.getDurationString() + "): " + testSuite;
                log.info(msg3);
                slr.info(msg3);
            }
            sw.end();
            if (jUnitResult != null) {
                jUnitResult.endTestSuite(testSuite);
            }
            if (htmlResult != null) {
                htmlResult.generate(testSuite);
            }
        }
    }
}

