/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.ScreenshotHandler;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.result.Warning;
import org.apache.commons.lang3.StringUtils;

public class CaptureEntirePageScreenshot
extends AbstractCommand {
    private static final int ARG_FILENAME = 0;

    CaptureEntirePageScreenshot(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE);
    }

    @Override
    public boolean mayUpdateScreen() {
        return false;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        if (!(context instanceof ScreenshotHandler)) {
            return new Success("captureEntirePageScreenshot is not supported.");
        }
        String filename = curArgs[0];
        if (StringUtils.isBlank((CharSequence)filename)) {
            return new Warning("captureEntirePageScreenshot is ignored: empty filename.");
        }
        ScreenshotHandler handler = (ScreenshotHandler)((Object)context);
        if (handler.isIgnoredScreenshotCommand()) {
            return new Success("captureEntirePageScreenshot is ignored.");
        }
        try {
            this.addScreenshot(handler.takeScreenshot(filename), "cmd");
            return Success.SUCCESS;
        }
        catch (UnsupportedOperationException e) {
            return new Warning(e.getMessage());
        }
    }
}

