/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Parser;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.Binder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestCaseParser
extends Parser {
    private final String baseURL;

    protected TestCaseParser(String filename, Document document, String baseURL) throws InvalidSeleneseException {
        super(filename, document);
        this.baseURL = baseURL;
    }

    private String getTdString(Node td) {
        StringBuilder value = new StringBuilder();
        for (Node node : TestCaseParser.each(td.getChildNodes())) {
            if ("BR".equals(node.getNodeName())) {
                value.append('\n');
                continue;
            }
            value.append(node.getTextContent());
        }
        return value.toString();
    }

    @Override
    public Selenese parse(ICommandFactory commandFactory) {
        String name = null;
        try {
            name = XPathAPI.selectSingleNode((Node)this.docucment, (String)"//THEAD/TR/TD").getTextContent();
            TestCase testCase = Binder.newTestCase(this.filename, name, this.baseURL);
            Node tbody = XPathAPI.selectSingleNode((Node)this.docucment, (String)"//TBODY");
            NodeList trList = tbody.getChildNodes();
            block6: for (Node tr : TestCaseParser.each(trList)) {
                ArrayList<String> cmdWithArgs;
                switch (tr.getNodeType()) {
                    case 1: {
                        cmdWithArgs = new ArrayList<String>(3);
                        for (Node td : TestCaseParser.each(tr.getChildNodes())) {
                            if (!"TD".equals(td.getNodeName())) continue;
                            cmdWithArgs.add(this.getTdString(td));
                        }
                        break;
                    }
                    case 8: {
                        cmdWithArgs = new ArrayList(2);
                        cmdWithArgs.add("comment");
                        cmdWithArgs.add(tr.getNodeValue().trim());
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                String cmdName = (String)cmdWithArgs.remove(0);
                String[] cmdArgs = cmdWithArgs.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
                testCase.addCommand(commandFactory, cmdName, cmdArgs);
            }
            return testCase;
        }
        catch (TransformerException e) {
            if (name == null) {
                name = FilenameUtils.getBaseName((String)this.filename);
            }
            return Binder.newErrorTestCase(name, new InvalidSeleneseException(e));
        }
    }
}

