/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.ErrorTestCase;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.TestCaseParser;
import jp.vmi.selenium.selenese.TestSuite;
import jp.vmi.selenium.selenese.TestSuiteParser;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.Binder;
import jp.vmi.selenium.selenese.utils.PathUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xpath.XPathAPI;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class Parser {
    private static final String TEST_CASE_PROFILE = "http://selenium-ide.openqa.org/profiles/test-case";
    private static final String DEFAULT_BASE_URL = "about:blank";
    protected final String filename;
    protected final Document docucment;

    protected static Iterable<Node> each(final NodeList nodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new NodeIterator(nodeList);
            }
        };
    }

    @Deprecated
    public static Selenese parse(String filename, InputStream is, Runner runner) {
        Selenese selenese = Parser.parse(filename, is, runner.getCommandFactory());
        Parser.setContextForBackwardCompatibility(selenese, runner);
        return selenese;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selenese parse(String filename, InputStream is, ICommandFactory commandFactory) {
        try {
            DOMParser dp = new DOMParser();
            dp.setEntityResolver(null);
            dp.setFeature("http://xml.org/sax/features/namespaces", false);
            dp.setFeature("http://apache.org/xml/features/include-comments", true);
            dp.parse(new InputSource(is));
            Document document = dp.getDocument();
            Node seleniumBase = XPathAPI.selectSingleNode((Node)document, (String)"/HTML/HEAD/LINK[@rel='selenium.base']/@href");
            if (seleniumBase != null) {
                String baseURL = seleniumBase.getNodeValue();
                Selenese selenese = new TestCaseParser(filename, document, baseURL).parse(commandFactory);
                return selenese;
            }
            Node profile = XPathAPI.selectSingleNode((Node)document, (String)"/HTML/HEAD/@profile");
            if (profile != null && TEST_CASE_PROFILE.equals(profile.getNodeValue())) {
                Selenese selenese = new TestCaseParser(filename, document, DEFAULT_BASE_URL).parse(commandFactory);
                return selenese;
            }
            Node suiteTable = XPathAPI.selectSingleNode((Node)document, (String)"/HTML/BODY/TABLE[@id='suiteTable']");
            if (suiteTable != null) {
                Selenese selenese = new TestSuiteParser(filename, document).parse(commandFactory);
                return selenese;
            }
            ErrorTestCase errorTestCase = Binder.newErrorTestCase(filename, new InvalidSeleneseException("Not selenese script. Missing neither 'selenium.base' link nor table with 'suiteTable' id"));
            return errorTestCase;
        }
        catch (Exception e) {
            ErrorTestCase errorTestCase = Binder.newErrorTestCase(filename, new InvalidSeleneseException(e));
            return errorTestCase;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Deprecated
    public static Selenese parse(String filename, Runner runner) {
        Selenese selenese = Parser.parse(filename, runner.getCommandFactory());
        Parser.setContextForBackwardCompatibility(selenese, runner);
        return selenese;
    }

    public static Selenese parse(String filename, ICommandFactory commandFactory) {
        try {
            return Parser.parse(filename, (InputStream)new FileInputStream(filename), commandFactory);
        }
        catch (FileNotFoundException e) {
            return Binder.newErrorTestCase(filename, new InvalidSeleneseException(e.getMessage()));
        }
    }

    @Deprecated
    public static Selenese setContextForBackwardCompatibility(Selenese selenese, Context context) {
        if (selenese instanceof TestSuite) {
            for (Selenese child : ((TestSuite)selenese).getSeleneseList()) {
                Parser.setContextForBackwardCompatibility(child, context);
            }
        } else if (selenese instanceof TestCase) {
            ((TestCase)selenese).setContext(context);
        }
        return selenese;
    }

    protected Parser(String filename, Document document) {
        this.filename = PathUtils.normalize(filename);
        this.docucment = document;
    }

    protected abstract Selenese parse(ICommandFactory var1);

    protected static class NodeIterator
    implements Iterator<Node> {
        private final NodeList nodeList;
        private int index = 0;

        protected NodeIterator(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.nodeList.getLength();
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nodeList.item(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

