/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class SeleniumUtils {
    public static String getVersion() {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = SeleniumUtils.class.getResourceAsStream("/META-INF/maven/org.seleniumhq.selenium/selenium-java/pom.properties");
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return props.getProperty("version", "<unknown>");
    }

    public static boolean patternMatches(String pattern, CharSequence input) {
        String[] p = pattern.split(":", 2);
        if (p.length == 2) {
            String type = p[0].toLowerCase();
            if ("regexp".equals(type)) {
                return SeleniumUtils.regexpMatches(p[1], input, 0);
            }
            if ("regexpi".equals(type)) {
                return SeleniumUtils.regexpMatches(p[1], input, 2);
            }
            if ("exact".equals(type)) {
                return StringUtils.equals((CharSequence)input, (CharSequence)p[1]);
            }
            if ("glob".equals(type)) {
                pattern = p[1];
            }
        }
        return SeleniumUtils.globMatches(pattern, input);
    }

    private static boolean regexpMatches(String pattern, CharSequence input, int flags) {
        Pattern p = Pattern.compile(pattern, flags);
        Matcher m = p.matcher(input);
        return m.find();
    }

    private static boolean globMatches(String pattern, CharSequence input) {
        Pattern p = Pattern.compile("\\Q" + pattern.replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q"), 32);
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public static <T> String convertToString(T result) {
        if (result == null) {
            return "";
        }
        if (result instanceof Object[]) {
            return StringUtils.join((Object[])((Object[])result), (char)',');
        }
        if (result instanceof Iterable) {
            return StringUtils.join((Iterable)((Iterable)result), (char)',');
        }
        if (result instanceof Iterator) {
            return StringUtils.join((Iterator)((Iterator)result), (char)',');
        }
        return result.toString();
    }
}

