/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FilenameUtils;

public class PathUtils {
    private static final Pattern SEP_REGEX = Pattern.compile("[/\\\\]");
    private static final String SEP_REPL = Matcher.quoteReplacement(File.separator);
    private static final String PARENT_DIR = ".." + File.separator;

    private static FilenameFilter getExeMatcher(String matchingName) {
        return OS.isFamilyWindows() ? new WinExeMatcher(matchingName) : new UnixExeMatcher(matchingName);
    }

    public static File searchExecutableFile(String filename) {
        FilenameFilter exeMatcher = PathUtils.getExeMatcher(filename);
        String[] curList = new File(".").list(exeMatcher);
        if (curList != null && curList.length > 0) {
            return new File(".", curList[0]);
        }
        for (String path : System.getenv("PATH").split(Pattern.quote(File.pathSeparator))) {
            String[] list;
            File dir = new File(path);
            if (!dir.isDirectory() || (list = dir.list(exeMatcher)) == null || list.length <= 0) continue;
            return new File(dir, list[0]);
        }
        return null;
    }

    public static String normalize(String filename) {
        String nfn;
        if (filename == null) {
            return null;
        }
        if ((filename = SEP_REGEX.matcher(filename).replaceAll(SEP_REPL)).startsWith(PARENT_DIR)) {
            filename = new File(filename).getAbsolutePath();
        }
        if ((nfn = FilenameUtils.normalize((String)filename)) == null) {
            try {
                nfn = new File(filename).getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Filename normalization failed: " + filename, e);
            }
        }
        return nfn;
    }

    private static class UnixExeMatcher
    implements FilenameFilter {
        private final String matchingName;

        public UnixExeMatcher(String matchingName) {
            this.matchingName = matchingName;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.equals(this.matchingName);
        }
    }

    private static class WinExeMatcher
    implements FilenameFilter {
        private final String[] exts;
        private final String matchingName;

        public WinExeMatcher(String matchingName) {
            String pathext = System.getenv("PATHEXT");
            this.exts = pathext != null ? pathext.split(";") : new String[]{};
            this.matchingName = matchingName;
        }

        @Override
        public boolean accept(File dir, String name) {
            return FilenameUtils.isExtension((String)name, (String[])this.exts) && FilenameUtils.getBaseName((String)name).equalsIgnoreCase(this.matchingName) || name.equalsIgnoreCase(this.matchingName);
        }
    }
}

