/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.NullContext;
import jp.vmi.selenium.selenese.command.CommandFactory;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.subcommand.ISubCommand;
import jp.vmi.selenium.selenese.subcommand.SubCommandMap;
import jp.vmi.selenium.selenese.subcommand.WDCommand;
import org.apache.commons.lang3.StringUtils;

public class CommandDumper {
    private static final Pattern GETTER = Pattern.compile("(get|is)([A-Z].*)");

    private static String append(String s1, String s2) {
        if (StringUtils.isEmpty((CharSequence)s1)) {
            return s2;
        }
        return s1 + ", " + s2;
    }

    private static void addCommandInformationFromSubCommandMap(Map<String, String> commands) {
        try {
            SubCommandMap subCommandMap = new SubCommandMap(new NullContext());
            for (Map.Entry<String, ISubCommand<?>> entry : subCommandMap.getMap().entrySet()) {
                Matcher matcher;
                String name = entry.getKey();
                ISubCommand<?> command = entry.getValue();
                String info = "";
                if (command instanceof WDCommand) {
                    info = CommandDumper.append(info, "WD");
                    if (((WDCommand)command).isNoOp()) {
                        info = CommandDumper.append(info, "NOP");
                    }
                } else {
                    info = CommandDumper.append(info, "SR");
                }
                if ((matcher = GETTER.matcher(name)).matches()) {
                    String getterInfo = CommandDumper.append(info, "Generated from " + name);
                    String targetName = matcher.group(2);
                    commands.put("assert" + targetName, getterInfo);
                    commands.put("verify" + targetName, getterInfo);
                    commands.put("waitFor" + targetName, getterInfo);
                    commands.put("store" + targetName, getterInfo);
                    if (targetName.endsWith("Present")) {
                        String notName = targetName.replaceFirst("Present$", "NotPresent");
                        commands.put("assert" + notName, getterInfo);
                        commands.put("verify" + notName, getterInfo);
                        commands.put("waitFor" + notName, getterInfo);
                        continue;
                    }
                    commands.put("assertNot" + targetName, getterInfo);
                    commands.put("verifyNot" + targetName, getterInfo);
                    commands.put("waitForNot" + targetName, getterInfo);
                    continue;
                }
                commands.put(name, info);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private static void addCommandInformationFromCommandFactory(Map<String, String> commandInfo) {
        String info = "SR";
        for (Map.Entry<String, Constructor<? extends ICommand>> entry : CommandFactory.getCommandEntries()) {
            String name = entry.getKey();
            String addInfo = commandInfo.containsKey(name) ? ",Override" : "";
            commandInfo.put(name, info + addInfo);
        }
        commandInfo.put("store", info);
    }

    public static void main(String[] args) {
        HashMap<String, String> commandInfo = new HashMap<String, String>();
        CommandDumper.addCommandInformationFromSubCommandMap(commandInfo);
        CommandDumper.addCommandInformationFromCommandFactory(commandInfo);
        ArrayList result = new ArrayList(commandInfo.entrySet());
        Collections.sort(result, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                return e1.getKey().compareTo(e2.getKey());
            }
        });
        for (Map.Entry entry : result) {
            System.out.println((String)entry.getKey() + "," + (String)entry.getValue());
        }
    }
}

