/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.log;

import java.util.Date;
import jp.vmi.selenium.selenese.log.CookieKey;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class CookieValue {
    private static final FastDateFormat expiryFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    public final CookieKey key;
    public final String value;
    public final Date expiry;

    public CookieValue(CookieKey key, String value, Date expiry) {
        this.key = key;
        this.value = value;
        this.expiry = expiry;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.key.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.expiry == null ? 0 : this.expiry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CookieValue other = (CookieValue)obj;
        return this.key.equals(other.key) && StringUtils.equals((CharSequence)this.value, (CharSequence)other.value) && (this.expiry != null ? this.expiry.equals(other.expiry) : other.expiry == null);
    }

    public String toString() {
        String expiryString = this.expiry != null ? expiryFormat.format(this.expiry) : "*";
        return this.key.name + "=[" + this.value + "]" + " (domain=" + this.key.domain + ", path=" + this.key.path + ", expire=" + expiryString + ")";
    }
}

