/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.util.ArrayList;
import java.util.List;
import jp.vmi.junit.result.ITestSuite;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Parser;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.ExecuteTestSuite;
import jp.vmi.selenium.selenese.log.PageInformation;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Unexecuted;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.selenese.utils.StopWatch;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuite
implements Selenese,
ITestSuite {
    private static final Logger log = LoggerFactory.getLogger(TestSuite.class);
    private String filename;
    private String parentDir = null;
    private String name;
    private final List<Selenese> seleneseList = new ArrayList<Selenese>();
    private final StopWatch stopWatch = new StopWatch();
    private Result result = Unexecuted.UNEXECUTED;

    public TestSuite initialize(String filename, String name) {
        this.filename = PathUtils.normalize(filename);
        if (filename != null) {
            this.parentDir = FilenameUtils.getFullPathNoEndSeparator((String)filename);
        }
        if (name != null) {
            this.name = name;
        } else if (filename != null) {
            this.name = FilenameUtils.getBaseName((String)filename);
        }
        return this;
    }

    @Override
    public Selenese.Type getType() {
        return Selenese.Type.TEST_SUITE;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addSelenese(Selenese selenese) {
        this.seleneseList.add(selenese);
    }

    public void addSeleneseFile(String filename, ICommandFactory commandFactory) {
        if (FilenameUtils.getPrefixLength((String)(filename = PathUtils.normalize(filename))) == 0 && this.parentDir != null) {
            filename = FilenameUtils.concat((String)this.parentDir, (String)filename);
        }
        this.addSelenese(Parser.parse(filename, commandFactory));
    }

    public List<Selenese> getSeleneseList() {
        return this.seleneseList;
    }

    @Override
    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    public Result getResult() {
        return this.result;
    }

    @Override
    @ExecuteTestSuite
    public Result execute(Selenese parent, Context context) {
        context.setLatestPageInformation(PageInformation.EMPTY);
        context.resetSpeed();
        for (Selenese selenese : this.seleneseList) {
            Result r;
            try {
                r = selenese.execute(this, context);
            }
            catch (RuntimeException e) {
                String msg = e.getMessage();
                this.result = new Error(msg);
                log.error(msg);
                throw e;
            }
            catch (InvalidSeleneseException e) {
                r = new Error(e);
            }
            this.result = this.result.update(r);
        }
        return this.result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("TestSuite[").append(this.name).append("]");
        if (this.filename != null) {
            s.append(" (").append(this.filename).append(")");
        }
        return s.toString();
    }
}

