/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.script;

import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import jp.vmi.script.JSWrapper;

public abstract class JSList<E>
extends AbstractList<E> {
    public abstract Object unwrap();

    public static <E> List<E> toList(ScriptEngine engine, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof Map) {
            return new JSMapList(object);
        }
        return new JSNativeList(engine, object);
    }

    static class JSNativeList<E>
    extends JSList<E> {
        private final JSWrapper wrapper;

        JSNativeList(ScriptEngine engine, Object object) {
            this.wrapper = new JSWrapper(engine, object);
        }

        @Override
        public E get(int index) {
            return (E)this.wrapper.eval("object[args[0]]", index);
        }

        @Override
        public int size() {
            Number result = (Number)this.wrapper.eval("object.length", new Object[0]);
            return result.intValue();
        }

        @Override
        public Object unwrap() {
            return this.wrapper.unwrap();
        }
    }

    static class JSMapList<E>
    extends JSList<E> {
        private final Map<?, E> map;

        JSMapList(Object object) {
            this.map = (Map)object;
        }

        @Override
        public E get(int index) {
            return this.map.get(index);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Object unwrap() {
            return this.map;
        }
    }
}

