/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.junit.result;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import jp.vmi.junit.result.FailsafeSummary;
import jp.vmi.junit.result.ITestCase;
import jp.vmi.junit.result.ITestSuite;
import jp.vmi.junit.result.ObjectFactory;
import jp.vmi.junit.result.TestCaseResult;
import jp.vmi.junit.result.TestResult;
import jp.vmi.junit.result.TestSuiteResult;

public final class JUnitResult {
    public static final String FAILSAFE_SUMMARY_FILENAME = "failsafe-summary.xml";
    private String xmlResultDir = null;
    private final JAXBContext context = this.initContext();
    private final Map<Object, TestResult<?>> map = new ConcurrentHashMap();
    private final FailsafeSummary failsafeSummary = ObjectFactory.factory.createFailsafeSummary();

    private JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDir(String dir) {
        this.xmlResultDir = dir;
    }

    public void startTestSuite(ITestSuite testSuite) {
        this.map.put(testSuite, ObjectFactory.factory.createTestSuiteResult(testSuite));
    }

    public void endTestSuite(ITestSuite testSuite) {
        TestSuiteResult suiteResult = (TestSuiteResult)this.map.remove(testSuite);
        if (this.xmlResultDir == null || suiteResult.getTests() == 0) {
            return;
        }
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            File file = new File(this.xmlResultDir, "TEST-" + suiteResult.getName() + ".xml");
            marshaller.marshal((Object)suiteResult, file);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public void addProperty(ITestSuite testSuite, String name, String value) {
        TestSuiteResult suiteResult = (TestSuiteResult)this.map.get(testSuite);
        suiteResult.addProperty(name, value);
    }

    public void startTestCase(ITestSuite testSuite, ITestCase testCase) {
        TestCaseResult caseResult = ObjectFactory.factory.createTestCaseResult(testCase);
        this.map.put(testCase, caseResult);
        if (testSuite != null) {
            TestSuiteResult suiteResult = (TestSuiteResult)this.map.get(testSuite);
            suiteResult.addTestCaseResult(caseResult);
        }
    }

    public void endTestCase(ITestCase testCase) {
        TestCaseResult caseResult = (TestCaseResult)this.map.remove(testCase);
        this.failsafeSummary.skipped += caseResult.getSkipped().intValue();
    }

    public void setSuccess(ITestCase testCase) {
        TestCaseResult caseResult = (TestCaseResult)this.map.get(testCase);
        caseResult.setSuccess();
        ++this.failsafeSummary.completed;
    }

    public void setError(ITestCase testCase, String message, String trace) {
        TestCaseResult caseResult = (TestCaseResult)this.map.get(testCase);
        caseResult.setError(message, trace);
        ++this.failsafeSummary.completed;
        ++this.failsafeSummary.errors;
    }

    public void setFailure(ITestCase testCase, String message, String trace) {
        TestCaseResult caseResult = (TestCaseResult)this.map.get(testCase);
        caseResult.setFailure(message, trace);
        ++this.failsafeSummary.completed;
        ++this.failsafeSummary.failures;
    }

    public void generateFailsafeSummary() {
        if (this.xmlResultDir == null) {
            return;
        }
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            File file = new File(this.xmlResultDir, FAILSAFE_SUMMARY_FILENAME);
            marshaller.marshal((Object)this.failsafeSummary, file);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

