/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.html.result;

import com.floreysoft.jmte.AnnotationProcessor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.token.AnnotationToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import jp.vmi.html.result.HtmlEscapeRenderer;
import jp.vmi.html.result.IndexRenderer;
import jp.vmi.html.result.NodeRenderer;
import jp.vmi.html.result.ResultRenderer;
import jp.vmi.html.result.TestSuiteSummary;
import jp.vmi.html.result.TestSuiteTree;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.TestSuite;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class HtmlResult {
    private String htmlResultDir = null;
    private Engine engine = null;
    private final TestSuiteTree tree = new TestSuiteTree();

    public void setDir(String dir) {
        this.htmlResultDir = dir;
    }

    private String getTemplate(String filename) {
        String string;
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(filename);
            string = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    private Engine getEngine() {
        if (this.engine == null) {
            this.engine = Engine.createCompilingEngine();
            this.engine.registerNamedRenderer((NamedRenderer)new HtmlEscapeRenderer());
            this.engine.registerNamedRenderer((NamedRenderer)new IndexRenderer());
            this.engine.registerRenderer(Result.class, (Renderer)new ResultRenderer());
            this.engine.registerRenderer(TestSuiteTree.Node.class, (Renderer)new NodeRenderer(this.engine, this.getTemplate("index-node.html")));
            this.engine.registerAnnotationProcessor((AnnotationProcessor)new AnnoSet());
            this.engine.registerAnnotationProcessor((AnnotationProcessor)new AnnoInc());
        }
        return this.engine;
    }

    public TestSuiteSummary generate(TestSuite testSuite) {
        if (this.htmlResultDir == null) {
            return null;
        }
        TestSuiteSummary summary = this.tree.getSummary(testSuite);
        if (summary != null) {
            return summary;
        }
        List<Selenese> seleneseList = testSuite.getSeleneseList();
        summary = new TestSuiteSummary();
        for (Selenese selenese : seleneseList) {
            switch (selenese.getType()) {
                case TEST_SUITE: {
                    if (selenese.isError()) break;
                    summary.merge(this.generate((TestSuite)selenese));
                    break;
                }
                case TEST_CASE: {
                    ++summary.numTestTotal;
                    if (selenese.isError()) {
                        ++summary.numTestFailures;
                        break;
                    }
                    TestCase testCase = (TestCase)selenese;
                    switch (testCase.getResult().getLevel()) {
                        case UNEXECUTED: {
                            break;
                        }
                        case SUCCESS: 
                        case WARNING: {
                            ++summary.numTestPasses;
                            break;
                        }
                        case FAILURE: 
                        case ERROR: {
                            ++summary.numTestFailures;
                        }
                    }
                    for (ICommand command : testCase.getCommandList()) {
                        switch (command.getResult().getLevel()) {
                            case UNEXECUTED: {
                                break;
                            }
                            case SUCCESS: 
                            case WARNING: {
                                ++summary.numCommandPasses;
                                break;
                            }
                            case FAILURE: {
                                ++summary.numCommandFailures;
                                break;
                            }
                            case ERROR: {
                                ++summary.numCommandErrors;
                            }
                        }
                    }
                    break;
                }
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("title", testSuite.getName() + " results");
        model.put("seleniumVersion", SeleniumUtils.getVersion());
        model.put("testSuite", testSuite);
        model.put("seleneseList", seleneseList);
        model.put("numTestTotal", summary.numTestTotal);
        model.put("numTestPasses", summary.numTestPasses);
        model.put("numTestFailures", summary.numTestFailures);
        model.put("numCommandPasses", summary.numCommandPasses);
        model.put("numCommandFailures", summary.numCommandFailures);
        model.put("numCommandErrors", summary.numCommandErrors);
        String html = this.getEngine().transform(this.getTemplate("result.html"), model);
        File file = new File(this.htmlResultDir, "TEST-" + testSuite.getName() + ".html");
        try {
            FileUtils.write((File)file, (CharSequence)html);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tree.add(testSuite, summary);
        return summary;
    }

    public void generateIndex() {
        if (this.htmlResultDir == null) {
            return;
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("title", "Index of test-suite results.");
        model.put("tree", this.tree);
        String html = this.getEngine().transform(this.getTemplate("index.html"), model);
        File file = new File(this.htmlResultDir, "index.html");
        try {
            FileUtils.write((File)file, (CharSequence)html);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class AnnoInc
    implements AnnotationProcessor<String> {
        private AnnoInc() {
        }

        public String getType() {
            return "inc";
        }

        public String eval(AnnotationToken token, TemplateContext context) {
            String key = token.getArguments();
            int value = NumberUtils.toInt((String)context.model.get((Object)key).toString());
            context.model.put(key, (Object)(value + 1));
            return null;
        }
    }

    private static class AnnoSet
    implements AnnotationProcessor<String> {
        private AnnoSet() {
        }

        public String getType() {
            return "set";
        }

        public String eval(AnnotationToken token, TemplateContext context) {
            String[] args = token.getArguments().split("\\s+");
            context.model.put(args[0], (Object)args[1]);
            return null;
        }
    }
}

