/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.colyseus.Connection;
import io.colyseus.serializer.SchemaSerializer;
import io.colyseus.serializer.schema.Schema;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Room<T extends Schema> {
    public T state;
    private Class<T> stateType;
    private String id;
    private String sessionId;
    private String name;
    private Listener listener;
    private Connection connection;
    private byte[] _previousState;
    private ObjectMapper msgpackMapper;
    private SchemaSerializer<T> serializer;
    private int previousCode;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    Room(Class<T> type, String roomName) {
        this.stateType = type;
        this.name = roomName;
        this.msgpackMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        try {
            this.serializer = new SchemaSerializer<T>(this.stateType);
            this.state = this.serializer.state;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    void connect(String endpoint, Map<String, String> httpHeaders) throws URISyntaxException {
        this.connection = new Connection(new URI(endpoint), httpHeaders, new Connection.Listener(){

            @Override
            public void onError(Exception e) {
                if (Room.this.listener != null) {
                    Room.this.listener.onError(e);
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                if (code == 1002 && reason != null && reason.startsWith("Invalid status code received: 401") && Room.this.listener != null) {
                    Room.this.listener.onError(new Exception(reason));
                }
                if (Room.this.listener != null) {
                    Room.this.listener.onLeave(code);
                }
            }

            @Override
            public void onOpen() {
            }

            @Override
            public void onMessage(ByteBuffer buf) {
                Room.this.onMessageCallback(buf);
            }
        });
    }

    private void onMessageCallback(ByteBuffer buf) {
        block21: {
            try {
                if (this.previousCode == 0) {
                    byte code = buf.get();
                    if (code == 10) {
                        byte[] bytes = new byte[buf.get()];
                        buf.get(bytes, 0, bytes.length);
                        String serializerId = new String(bytes, StandardCharsets.UTF_8);
                        if (serializerId.equals("fossil-delta")) {
                            throw new Error("fossil-delta is not supported");
                        }
                        if (buf.hasRemaining()) {
                            byte[] b = new byte[buf.remaining()];
                            buf.get(b, 0, b.length);
                            this.serializer.handshake(b);
                        }
                        if (this.listener != null) {
                            this.listener.onJoin();
                        }
                    } else if (code == 11) {
                        byte length = buf.get();
                        byte[] bytes = new byte[length];
                        buf.get(bytes, 0, length);
                        String message = new String(bytes, StandardCharsets.UTF_8);
                        if (this.listener != null) {
                            this.listener.onError(new Exception(message));
                        }
                    } else if (code == 12) {
                        this.leave();
                    } else {
                        this.previousCode = code;
                    }
                } else {
                    if (buf.hasRemaining()) {
                        if (this.previousCode == 14) {
                            byte[] bytes = new byte[buf.remaining()];
                            buf.get(bytes);
                            this.setState(bytes);
                        } else if (this.previousCode == 15) {
                            byte[] bytes = new byte[buf.remaining()];
                            buf.get(bytes);
                            this.patch(bytes);
                        } else if (this.previousCode == 13) {
                            byte[] bytes = new byte[buf.remaining()];
                            buf.get(bytes);
                            Object data = this.msgpackMapper.readValue(bytes, (TypeReference)new TypeReference<Object>(){});
                            if (this.listener != null) {
                                this.listener.onMessage(data);
                            }
                        }
                    }
                    this.previousCode = 0;
                }
            }
            catch (Exception e) {
                this.leave(false);
                if (this.listener == null) break block21;
                this.listener.onError(e);
            }
        }
    }

    private void dispatchOnMessage(Object message) {
        if (this.listener != null) {
            this.listener.onMessage(message);
        }
    }

    public void leave() {
        this.leave(true);
    }

    public void leave(boolean consented) {
        if (this.connection != null) {
            if (consented) {
                this.connection.send(12);
            } else {
                this.connection.close();
            }
        } else if (this.listener != null) {
            this.listener.onLeave(4000);
        }
    }

    public void send(Object data) {
        if (this.connection != null) {
            this.connection.send(13, data);
        } else if (this.listener != null) {
            this.listener.onError(new Exception("send error: Room is created but not joined yet"));
        }
    }

    public boolean hasJoined() {
        return this.sessionId != null;
    }

    private void setState(byte[] encodedState) throws NullPointerException, ArrayIndexOutOfBoundsException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        this.serializer.setState(encodedState);
        if (this.listener != null) {
            this.listener.onStateChange(((Schema)this.serializer.state)._clone(), true);
        }
    }

    private void patch(byte[] delta) throws NullPointerException, ArrayIndexOutOfBoundsException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        this.serializer.patch(delta);
        if (this.listener != null) {
            this.listener.onStateChange(this.serializer.state, false);
        }
    }

    public static abstract class Listener<T extends Schema> {
        protected Listener() {
        }

        protected void onLeave(int code) {
        }

        protected void onError(Exception e) {
        }

        protected void onMessage(Object message) {
        }

        protected void onJoin() {
        }

        protected void onStateChange(T state, boolean isFirstState) {
        }
    }
}

