/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus.serializer.schema;

import io.colyseus.serializer.schema.Iterator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class Decoder {
    private static Decoder instance;

    private Decoder() {
    }

    public static Decoder getInstance() {
        if (instance == null) {
            instance = new Decoder();
        }
        return instance;
    }

    public Object decodePrimitiveType(String type, byte[] bytes, Iterator it) {
        switch (type) {
            case "string": {
                return this.decodeString(bytes, it);
            }
            case "number": {
                return Float.valueOf(this.decodeNumber(bytes, it));
            }
            case "int8": {
                return this.decodeInt8(bytes, it);
            }
            case "uint8": {
                return this.decodeUint8(bytes, it);
            }
            case "int16": {
                return this.decodeInt16(bytes, it);
            }
            case "uint16": {
                return this.decodeUint16(bytes, it);
            }
            case "int32": {
                return this.decodeInt32(bytes, it);
            }
            case "uint32": {
                return this.decodeUint32(bytes, it);
            }
            case "int64": {
                return this.decodeInt64(bytes, it);
            }
            case "uint64": {
                return this.decodeUint64(bytes, it);
            }
            case "float32": {
                return Float.valueOf(this.decodeFloat32(bytes, it));
            }
            case "float64": {
                return this.decodeFloat64(bytes, it);
            }
            case "boolean": {
                return this.decodeBoolean(bytes, it);
            }
        }
        return null;
    }

    public float decodeNumber(byte[] bytes, Iterator it) {
        int prefix;
        if ((prefix = bytes[it.offset++] & 0xFF) < 128) {
            return prefix;
        }
        if (prefix == 202) {
            return this.decodeFloat32(bytes, it);
        }
        if (prefix == 203) {
            return (float)this.decodeFloat64(bytes, it);
        }
        if (prefix == 204) {
            return this.decodeUint8(bytes, it);
        }
        if (prefix == 205) {
            return this.decodeUint16(bytes, it);
        }
        if (prefix == 206) {
            return this.decodeUint32(bytes, it);
        }
        if (prefix == 207) {
            return this.decodeUint64(bytes, it);
        }
        if (prefix == 208) {
            return this.decodeInt8(bytes, it);
        }
        if (prefix == 209) {
            return this.decodeInt16(bytes, it);
        }
        if (prefix == 210) {
            return this.decodeInt32(bytes, it);
        }
        if (prefix == 211) {
            return this.decodeInt64(bytes, it);
        }
        if (prefix > 223) {
            return (255 - prefix + 1) * -1;
        }
        return Float.NaN;
    }

    public byte decodeInt8(byte[] bytes, Iterator it) {
        return bytes[it.offset++];
    }

    public short decodeUint8(byte[] bytes, Iterator it) {
        return (short)(bytes[it.offset++] & 0xFF);
    }

    public short decodeInt16(byte[] bytes, Iterator it) {
        short ret = ByteBuffer.wrap(bytes, it.offset, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
        it.offset += 2;
        return ret;
    }

    public int decodeUint16(byte[] bytes, Iterator it) {
        int ret = ByteBuffer.wrap(bytes, it.offset, 2).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFF;
        it.offset += 2;
        return ret;
    }

    public int decodeInt32(byte[] bytes, Iterator it) {
        int ret = ByteBuffer.wrap(bytes, it.offset, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        it.offset += 4;
        return ret;
    }

    public long decodeUint32(byte[] bytes, Iterator it) {
        long ret = (long)ByteBuffer.wrap(bytes, it.offset, 4).order(ByteOrder.LITTLE_ENDIAN).getInt() & 0xFFFFFFFFL;
        it.offset += 4;
        return ret;
    }

    public float decodeFloat32(byte[] bytes, Iterator it) {
        float ret = ByteBuffer.wrap(bytes, it.offset, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat();
        it.offset += 4;
        return ret;
    }

    public double decodeFloat64(byte[] bytes, Iterator it) {
        double ret = ByteBuffer.wrap(bytes, it.offset, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        it.offset += 8;
        return ret;
    }

    public long decodeInt64(byte[] bytes, Iterator it) {
        long ret = ByteBuffer.wrap(bytes, it.offset, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
        it.offset += 8;
        return ret;
    }

    public long decodeUint64(byte[] bytes, Iterator it) {
        long ret = ByteBuffer.wrap(bytes, it.offset, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
        it.offset += 8;
        return ret;
    }

    public boolean decodeBoolean(byte[] bytes, Iterator it) {
        return this.decodeUint8(bytes, it) > 0;
    }

    public String decodeString(byte[] bytes, Iterator it) {
        int prefix = bytes[it.offset++] & 0xFF;
        int length = 0;
        if (prefix < 192) {
            length = prefix & 0x1F;
        } else if (prefix == 217) {
            length = this.decodeUint8(bytes, it);
        } else if (prefix == 218) {
            length = this.decodeUint16(bytes, it);
        } else if (prefix == 219) {
            length = (int)this.decodeUint32(bytes, it);
        }
        byte[] _bytes = new byte[length];
        System.arraycopy(bytes, it.offset, _bytes, 0, length);
        String str = new String(_bytes, StandardCharsets.UTF_8);
        it.offset += length;
        return str;
    }

    public boolean nilCheck(byte[] bytes, Iterator it) {
        return bytes[it.offset] == -64;
    }

    public boolean indexChangeCheck(byte[] bytes, Iterator it) {
        return bytes[it.offset] == -44;
    }

    public boolean numberCheck(byte[] bytes, Iterator it) {
        int prefix = bytes[it.offset] & 0xFF;
        return prefix < 128 || prefix >= 202 && prefix <= 211;
    }
}

