/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.colyseus.Connection;
import io.colyseus.fossil_delta.FossilDelta;
import io.colyseus.state_listener.StateContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Room
extends StateContainer {
    private LinkedHashMap<String, Object> options;
    private String id;
    private String sessionId;
    private String name;
    private List<Listener> listeners = new ArrayList<Listener>();
    private Connection connection;
    private byte[] _previousState;
    private ObjectMapper msgpackMapper;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    LinkedHashMap<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(LinkedHashMap<String, Object> options) {
        this.options = options;
    }

    public LinkedHashMap<String, Object> getState() {
        return this.state;
    }

    Room(String roomName, LinkedHashMap<String, Object> options) {
        super(new LinkedHashMap<String, Object>());
        this.name = roomName;
        this.options = options;
        this.msgpackMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    void connect(String endpoint, Map<String, String> httpHeaders, int connectTimeout) throws URISyntaxException {
        this.connection = new Connection(new URI(endpoint), connectTimeout, httpHeaders, new Connection.Listener(){

            @Override
            public void onError(Exception e) {
                for (Listener listener : Room.this.listeners) {
                    if (listener == null) continue;
                    listener.onError(e);
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                if (code == 1002 && reason != null && reason.startsWith("Invalid status code received: 401")) {
                    for (Listener listener : Room.this.listeners) {
                        if (listener == null) continue;
                        listener.onError(new Exception(reason));
                    }
                }
                for (Listener listener : Room.this.listeners) {
                    if (listener == null) continue;
                    listener.onLeave();
                }
                Room.this.removeAllListeners();
            }

            @Override
            public void onOpen() {
            }

            @Override
            public void onMessage(byte[] bytes) {
                Room.this.onMessageCallback(bytes);
            }
        });
    }

    private void onMessageCallback(byte[] bytes) {
        block16: {
            try {
                Object message = this.msgpackMapper.readValue(bytes, (TypeReference)new TypeReference<Object>(){});
                if (message instanceof List) {
                    List messageArray = (List)message;
                    if (messageArray.get(0) instanceof Integer) {
                        int code = (Integer)messageArray.get(0);
                        switch (code) {
                            case 10: {
                                this.sessionId = (String)messageArray.get(1);
                                for (Listener listener : this.listeners) {
                                    if (listener == null) continue;
                                    listener.onJoin();
                                }
                                break block16;
                            }
                            case 11: {
                                System.err.println("Error: " + messageArray.get(1));
                                for (Listener listener : this.listeners) {
                                    if (listener == null) continue;
                                    listener.onError(new Exception(messageArray.get(1).toString()));
                                }
                                break block16;
                            }
                            case 14: {
                                this.setState((byte[])messageArray.get(1));
                                break;
                            }
                            case 15: {
                                this.patch((ArrayList)messageArray.get(1));
                                break;
                            }
                            case 13: {
                                for (Listener listener : this.listeners) {
                                    if (listener == null) continue;
                                    listener.onMessage(messageArray.get(1));
                                }
                                break block16;
                            }
                            case 12: {
                                this.leave();
                                break;
                            }
                            default: {
                                this.dispatchOnMessage(message);
                            }
                        }
                        break block16;
                    }
                    this.dispatchOnMessage(message);
                    break block16;
                }
                this.dispatchOnMessage(message);
            }
            catch (Exception e) {
                for (Listener listener : this.listeners) {
                    if (listener == null) continue;
                    listener.onError(e);
                }
            }
        }
    }

    private void dispatchOnMessage(Object message) {
        for (Listener listener : this.listeners) {
            if (listener == null) continue;
            listener.onMessage(message);
        }
    }

    @Override
    public void removeAllListeners() {
        super.removeAllListeners();
        this.listeners.clear();
    }

    public void leave() {
        if (this.connection != null) {
            this.connection.send(12);
        } else {
            for (Listener listener : this.listeners) {
                if (listener == null) continue;
                listener.onLeave();
            }
        }
    }

    public void send(Object data) {
        if (this.connection != null) {
            this.connection.send(13, this.id, data);
        } else {
            for (Listener listener : this.listeners) {
                if (listener == null) continue;
                listener.onError(new Exception("send error: Room is created but not joined yet"));
            }
        }
    }

    public boolean hasJoined() {
        return this.sessionId != null;
    }

    private void setState(byte[] encodedState) throws IOException {
        this.set((LinkedHashMap)this.msgpackMapper.readValue(encodedState, Object.class));
        this._previousState = encodedState;
        for (Listener listener : this.listeners) {
            if (listener == null) continue;
            listener.onStateChange(this.state);
        }
    }

    private void patch(ArrayList<Integer> binaryPatch) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Integer i : binaryPatch) {
            baos.write((int)(i & 0xFF));
        }
        this._previousState = FossilDelta.apply(this._previousState, baos.toByteArray());
        this.set((LinkedHashMap)this.msgpackMapper.readValue(this._previousState, Object.class));
        for (Listener listener : this.listeners) {
            if (listener == null) continue;
            listener.onStateChange(this.state);
        }
    }

    public static abstract class Listener {
        protected Listener() {
        }

        protected void onLeave() {
        }

        protected void onError(Exception e) {
        }

        protected void onMessage(Object message) {
        }

        protected void onJoin() {
        }

        protected void onStateChange(LinkedHashMap<String, Object> state) {
        }
    }
}

