/*
 * Decompiled with CFR 0.152.
 */
import io.colyseus.Client;
import io.colyseus.Room;
import io.colyseus.RoomListener;
import io.colyseus.state_listener.PatchObject;
import io.colyseus.state_listener.StateContainer;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class Main {
    static Client client;
    static Room room;

    public static void main(String[] args) {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("User-Agent", "Colyseus Client for Java");
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("a", 1);
        try {
            client = new Client("http://localhost:3000", options, httpHeaders, new Client.Listener(){

                @Override
                public void onOpen() {
                    System.out.println("Client.onOpen()");
                }

                @Override
                public void onMessage(Object message) {
                    System.out.println("Client.onMessage()");
                    System.out.println(message);
                }

                @Override
                public void onClose(int code, String reason, boolean remote) {
                    System.out.println("Client.onClose()");
                    System.out.println("code: " + code + ", reason: " + reason + ", remote: " + remote);
                }

                @Override
                public void onError(Exception e) {
                    System.out.println("Client.onError()");
                    e.printStackTrace();
                }
            });
            room = client.join("public", null, 10);
            room.addListener(new RoomListener(){

                @Override
                protected void onLeave() {
                    System.out.println("Room.onLeave()");
                }

                @Override
                protected void onError(Exception e) {
                    System.out.println("Room.onError()");
                    System.out.println("exception: " + e.getMessage());
                }

                @Override
                protected void onMessage(Object message) {
                    System.out.println("Room.onMessage()");
                    System.out.println("message: " + message);
                }

                @Override
                protected void onJoin() {
                    System.out.println("Room.onJoin()");
                }

                @Override
                protected void onStateChange(LinkedHashMap<String, Object> state) {
                }
            });
            room.setDefaultPatchListener(new StateContainer.FallbackPatchListenerCallback(){

                @Override
                public void callback(PatchObject patchObject) {
                }
            });
            room.addPatchListener("players/:id/:attribute", new StateContainer.PatchListenerCallback(){

                @Override
                protected void callback(StateContainer.DataChange dataChange) {
                    System.out.println("change: " + dataChange);
                }
            });
            client.getAvailableRooms("public", new Client.GetAvailableRoomsCallback(){

                @Override
                public void onCallback(List<Client.AvailableRoom> roomsAvailable, String error) {
                    System.out.println(roomsAvailable.toString());
                    if (error != null) {
                        System.out.println(error);
                    }
                }
            });
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

