/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus.state_listener;

import io.colyseus.state_listener.Compare;
import io.colyseus.state_listener.DataChange;
import io.colyseus.state_listener.FallbackPatchListener;
import io.colyseus.state_listener.FallbackPatchListenerCallback;
import io.colyseus.state_listener.PatchListener;
import io.colyseus.state_listener.PatchListenerCallback;
import io.colyseus.state_listener.PatchObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StateContainer {
    public LinkedHashMap<String, Object> state;
    private List<PatchListener> _listeners;
    private FallbackPatchListener defaultListener;
    private LinkedHashMap<String, Pattern> matcherPlaceholders = new LinkedHashMap();

    public StateContainer(LinkedHashMap<String, Object> state) {
        this.matcherPlaceholders.put(":id", Pattern.compile("^([a-zA-Z0-9\\-_]+)$"));
        this.matcherPlaceholders.put(":number", Pattern.compile("^([0-9]+)$"));
        this.matcherPlaceholders.put(":string", Pattern.compile("^(\\w+)$"));
        this.matcherPlaceholders.put(":axis", Pattern.compile("^([xyz])$"));
        this.matcherPlaceholders.put(":*", Pattern.compile("(.*)"));
        this.state = state;
        this.reset();
    }

    protected List<PatchObject> set(LinkedHashMap<String, Object> newData) {
        List<PatchObject> patches = Compare.compare(this.state, newData);
        this.checkPatches(patches);
        this.state = newData;
        return patches;
    }

    public void registerPlaceholder(String placeholder, Pattern regex) {
        this.matcherPlaceholders.put(placeholder, regex);
    }

    public FallbackPatchListener setDefaultPatchListener(FallbackPatchListenerCallback callback) {
        FallbackPatchListener listener;
        this.defaultListener = listener = new FallbackPatchListener(callback, new Pattern[0]);
        return listener;
    }

    public PatchListener addPatchListener(String segments, PatchListenerCallback callback) {
        String[] rawRules = segments.split("/");
        Pattern[] regexpRules = this.parseRegexRules(rawRules);
        PatchListener listener = new PatchListener(callback, regexpRules, rawRules);
        this._listeners.add(listener);
        return listener;
    }

    public void removePatchListener(PatchListener listener) {
        this._listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.reset();
    }

    private Pattern[] parseRegexRules(String[] rules) {
        Pattern[] regexpRules = new Pattern[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            String segment = rules[i];
            if (segment.indexOf(58) == 0) {
                if (this.matcherPlaceholders.containsKey(segment)) {
                    regexpRules[i] = this.matcherPlaceholders.get(segment);
                    continue;
                }
                regexpRules[i] = this.matcherPlaceholders.get(":*");
                continue;
            }
            regexpRules[i] = Pattern.compile("^" + segment + "$");
        }
        return regexpRules;
    }

    private void checkPatches(List<PatchObject> patches) {
        for (int i = patches.size() - 1; i >= 0; --i) {
            boolean matched = false;
            for (PatchListener listener : this._listeners) {
                LinkedHashMap<String, String> pathVariables = this.getPathVariables(patches.get(i), listener);
                if (pathVariables == null) continue;
                DataChange dataChange = new DataChange();
                dataChange.path = pathVariables;
                dataChange.operation = patches.get((int)i).operation;
                dataChange.value = patches.get((int)i).value;
                listener.callback.callback(dataChange);
                matched = true;
            }
            if (matched || this.defaultListener == null) continue;
            this.defaultListener.callback.callback(patches.get(i));
        }
    }

    private LinkedHashMap<String, String> getPathVariables(PatchObject patch, PatchListener listener) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (patch.path.size() != listener.rules.length) {
            return null;
        }
        for (int i = 0; i < listener.rules.length; ++i) {
            Matcher matcher = listener.rules[i].matcher(patch.path.get(i));
            ArrayList<String> matches = new ArrayList<String>();
            while (matcher.find()) {
                matches.add(matcher.group());
            }
            if (matches.size() == 0 || matches.size() > 2) {
                return null;
            }
            if (listener.rawRules[i].charAt(0) != ':') continue;
            result.put(listener.rawRules[i].substring(1), (String)matches.get(0));
        }
        return result;
    }

    private void reset() {
        this._listeners = new ArrayList<PatchListener>();
        this.defaultListener = null;
    }
}

