/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.colyseus.Connection;
import io.colyseus.fossil_delta.FossilDelta;
import io.colyseus.state_listener.StateContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Room
extends StateContainer {
    private LinkedHashMap<String, Object> options;
    private String id;
    private String sessionId;
    private String name;
    private List<RoomListener> listeners = new ArrayList<RoomListener>();
    private Connection connection;
    private byte[] _previousState;
    private ObjectMapper objectMapper;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    LinkedHashMap<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(LinkedHashMap<String, Object> options) {
        this.options = options;
    }

    public LinkedHashMap<String, Object> getState() {
        return this.state;
    }

    Room(String roomName, LinkedHashMap<String, Object> options) {
        super(new LinkedHashMap<String, Object>());
        System.out.println("Room created: name: " + roomName + ", options: " + options);
        this.name = roomName;
        this.options = options;
        this.objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
    }

    public void addListener(RoomListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RoomListener listener) {
        this.listeners.remove(listener);
    }

    void connect(String endpoint, Map<String, String> httpHeaders) throws Exception {
        this.connection = new Connection(endpoint, 10000, httpHeaders, new Connection.Listener(){

            @Override
            public void onError(Exception e) {
                System.err.println("Possible causes: room's onAuth() failed or maxClients has been reached.");
                ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
                for (RoomListener listener : Room.this.listeners) {
                    listener.onError(e);
                    if (!listener.once) continue;
                    toRemove.add(listener);
                }
                Room.this.listeners.removeAll(toRemove);
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                Room.this.removeAllListeners();
                ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
                for (RoomListener listener : Room.this.listeners) {
                    listener.onLeave();
                    if (!listener.once) continue;
                    toRemove.add(listener);
                }
                Room.this.listeners.removeAll(toRemove);
            }

            @Override
            public void onOpen() {
            }

            @Override
            public void onMessage(byte[] bytes) {
                Room.this.onMessageCallback(bytes);
            }
        });
    }

    public void onMessageCallback(byte[] bytes) {
        try {
            Object message = this.objectMapper.readValue(bytes, (TypeReference)new TypeReference<Object[]>(){});
            if (message instanceof Object[]) {
                Object[] messageArray = (Object[])message;
                if (messageArray[0] instanceof Integer) {
                    int code = (Integer)messageArray[0];
                    switch (code) {
                        case 10: {
                            this.sessionId = (String)messageArray[1];
                            ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
                            for (RoomListener listener : this.listeners) {
                                listener.onJoin();
                                if (!listener.once) continue;
                                toRemove.add(listener);
                            }
                            this.listeners.removeAll(toRemove);
                            break;
                        }
                        case 11: {
                            System.err.println("Error: " + messageArray[1]);
                            ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
                            for (RoomListener listener : this.listeners) {
                                listener.onError(new Exception(messageArray[1].toString()));
                                if (!listener.once) continue;
                                toRemove.add(listener);
                            }
                            this.listeners.removeAll(toRemove);
                            break;
                        }
                        case 14: {
                            this.setState((byte[])messageArray[1]);
                            break;
                        }
                        case 15: {
                            this.patch((ArrayList)messageArray[1]);
                            break;
                        }
                        case 13: {
                            ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
                            for (RoomListener listener : this.listeners) {
                                listener.onMessage(messageArray[1]);
                                if (!listener.once) continue;
                                toRemove.add(listener);
                            }
                            this.listeners.removeAll(toRemove);
                            break;
                        }
                        case 12: {
                            this.leave();
                            break;
                        }
                        default: {
                            this.dispatchOnMessage(message);
                            break;
                        }
                    }
                } else {
                    this.dispatchOnMessage(message);
                }
            } else {
                this.dispatchOnMessage(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
            for (RoomListener listener : this.listeners) {
                listener.onError(e);
                if (!listener.once) continue;
                toRemove.add(listener);
            }
            this.listeners.removeAll(toRemove);
        }
    }

    private void dispatchOnMessage(Object message) {
        ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
        for (RoomListener listener : this.listeners) {
            listener.onMessage(message);
            if (!listener.once) continue;
            toRemove.add(listener);
        }
        this.listeners.removeAll(toRemove);
    }

    @Override
    public void removeAllListeners() {
        super.removeAllListeners();
        this.listeners.clear();
    }

    public void leave() {
        if (this.connection != null) {
            this.connection.send(12);
        } else {
            ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
            for (RoomListener listener : this.listeners) {
                listener.onLeave();
                if (!listener.once) continue;
                toRemove.add(listener);
            }
            this.listeners.removeAll(toRemove);
        }
    }

    public void send(Object data) {
        this.connection.send(13, this.id, data);
    }

    public boolean hasJoined() {
        return this.sessionId != null;
    }

    protected void setState(byte[] encodedState) throws IOException {
        this.set((LinkedHashMap)this.objectMapper.readValue(encodedState, Object.class));
        this._previousState = encodedState;
        ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
        for (RoomListener listener : this.listeners) {
            listener.onStateChange(this.state);
            if (!listener.once) continue;
            toRemove.add(listener);
        }
        this.listeners.removeAll(toRemove);
    }

    protected void patch(ArrayList<Integer> binaryPatch) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < binaryPatch.size(); ++i) {
            baos.write((int)(binaryPatch.get(i) & 0xFF));
        }
        this._previousState = FossilDelta.apply(this._previousState, baos.toByteArray());
        this.set((LinkedHashMap)this.objectMapper.readValue(this._previousState, Object.class));
        ArrayList<RoomListener> toRemove = new ArrayList<RoomListener>();
        for (RoomListener listener : this.listeners) {
            listener.onStateChange(this.state);
            if (!listener.once) continue;
            toRemove.add(listener);
        }
        this.listeners.removeAll(toRemove);
    }

    public static abstract class RoomListener {
        boolean once = false;

        protected RoomListener() {
        }

        protected RoomListener(boolean once) {
            this.once = once;
        }

        protected void onLeave() {
        }

        protected void onError(Exception e) {
        }

        protected void onMessage(Object message) {
        }

        protected void onJoin() {
        }

        protected void onStateChange(LinkedHashMap<String, Object> state) {
        }
    }
}

