/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.deposits;

import ir.boommarket.Asserts;
import ir.boommarket.deposits.OrderType;
import ir.boommarket.deposits.StatementActionType;
import java.util.Date;

public class StatementListRequest {
    final String depositNumber;
    final Date fromDate;
    final Date toDate;
    final Long offset;
    final Long length;
    final OrderType order;
    final String description;
    final StatementActionType action;

    private StatementListRequest(String depositNumber, Date fromDate, Date toDate, Long offset, Long length, OrderType order, String description, StatementActionType action) {
        Asserts.notBlank(depositNumber, "depositNumber can't be a null or blank string");
        this.offsetNotNegative(offset);
        this.lengthNotNegative(length);
        this.validateTimeSpan(fromDate, toDate);
        this.depositNumber = depositNumber;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.offset = offset;
        this.length = length;
        this.order = order;
        this.description = description;
        this.action = action;
    }

    public static StatementListRequest withoutFilter() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void offsetNotNegative(Long offset) {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("offset can't be a negative number");
        }
    }

    private void lengthNotNegative(Long length) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("length can't be less than or equal to zero");
        }
    }

    private void validateTimeSpan(Date fromDate, Date toDate) {
        if (fromDate != null && toDate != null && fromDate.after(toDate)) {
            throw new IllegalArgumentException("toDate should be after the fromDate");
        }
    }

    public static class Builder {
        private String depositNumber;
        private Date fromDate;
        private Date toDate;
        private Long offset;
        private Long length;
        private OrderType order;
        private String description;
        private StatementActionType action;

        public Builder withDepositNumber(String depositNumber) {
            this.depositNumber = depositNumber;
            return this;
        }

        public Builder withFromDate(Date fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public Builder withToDate(Date toDate) {
            this.toDate = toDate;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder withLength(Long length) {
            this.length = length;
            return this;
        }

        public Builder withOrder(OrderType order) {
            this.order = order;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withAction(StatementActionType action) {
            this.action = action;
            return this;
        }

        public StatementListRequest build() {
            return new StatementListRequest(this.depositNumber, this.fromDate, this.toDate, this.offset, this.length, this.order, this.description, this.action);
        }
    }
}

