/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.deposits;

import ir.boommarket.Asserts;
import ir.boommarket.BoomApi;
import ir.boommarket.Json;
import ir.boommarket.Requests;
import ir.boommarket.deposits.AutoTransfer;
import ir.boommarket.deposits.AutoTransferReport;
import ir.boommarket.deposits.AutoTransferRequest;
import ir.boommarket.deposits.BatchTransfer;
import ir.boommarket.deposits.BatchTransferRequest;
import ir.boommarket.deposits.CancelAutoTransfer;
import ir.boommarket.deposits.Deposit;
import ir.boommarket.deposits.DepositHolder;
import ir.boommarket.deposits.DepositIban;
import ir.boommarket.deposits.DepositList;
import ir.boommarket.deposits.DepositListRequest;
import ir.boommarket.deposits.ListAutoTransfer;
import ir.boommarket.deposits.ListAutoTransferRequest;
import ir.boommarket.deposits.NormalTransfer;
import ir.boommarket.deposits.NormalTransferRequest;
import ir.boommarket.deposits.ReportAutoTransferRequest;
import ir.boommarket.deposits.StatementList;
import ir.boommarket.deposits.StatementListRequest;
import okhttp3.Request;

public class Deposits {
    public static Deposit getDetail(String depositNumber, BoomApi boomApi) {
        if (depositNumber == null || depositNumber.trim().isEmpty()) {
            throw new IllegalArgumentException("DepositNumber must not be null or a blank string");
        }
        String url = boomApi.baseUrl() + "deposits/" + depositNumber;
        Request.Builder builder = new Request.Builder();
        Request httpRequest = Requests.withCommonHeaders(builder, boomApi).url(url).get().build();
        return Requests.sendRequest(httpRequest, Deposit.class);
    }

    public static DepositHolder getHolder(String depositNumber, BoomApi boomApi) {
        if (depositNumber == null || depositNumber.trim().isEmpty()) {
            throw new IllegalArgumentException("DepositNumber must not be null or a blank string");
        }
        String url = boomApi.baseUrl() + "deposits/" + depositNumber + "/holder";
        Request.Builder builder = new Request.Builder();
        Request httpRequest = Requests.withCommonHeaders(builder, boomApi).url(url).get().build();
        return Requests.sendRequest(httpRequest, DepositHolder.class);
    }

    public static StatementList getStatements(StatementListRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "The request parameter can not be null");
        Asserts.notNull(boomApi, "The boomApi parameter can not be null");
        String url = boomApi.baseUrl() + "deposits/" + request.depositNumber + "/statements";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, StatementList.class);
    }

    public static DepositList getDeposits(DepositListRequest request, BoomApi boomApi) {
        if (request == null) {
            request = DepositListRequest.withoutFilter();
        }
        Asserts.notNull(boomApi, "BoomApi can not be null");
        String url = boomApi.baseUrl() + "deposits";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, DepositList.class);
    }

    public static DepositIban getIban(String depositNumber, BoomApi boomApi) {
        Asserts.notBlank(depositNumber, "DepositNumber must not be null or a blank string");
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "deposits/" + depositNumber + "/iban";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).get().build();
        return Requests.sendRequest(httpRequest, DepositIban.class);
    }

    public static NormalTransfer normalTransfer(NormalTransferRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request parameter can not be null");
        Asserts.notNull(boomApi, "boomApi parameter can not be null");
        String url = boomApi.baseUrl() + "deposits/transfer/normal";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, NormalTransfer.class);
    }

    public static AutoTransfer autoTransfer(AutoTransferRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "The request parameter can not be null");
        Asserts.notNull(boomApi, "The boomApi can not be null");
        String url = boomApi.baseUrl() + "deposits/transfer/auto";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, AutoTransfer.class);
    }

    public static CancelAutoTransfer cancelAutoTransfer(String serial, BoomApi boomApi) {
        Asserts.notBlank(serial, "Serial parameter can not be null or a blank string");
        Asserts.notNull(boomApi, "BoomApi can't be null");
        String url = boomApi.baseUrl() + "deposits/transfer/auto/" + serial;
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).delete().build();
        return Requests.sendRequest(httpRequest, CancelAutoTransfer.class);
    }

    public static AutoTransferReport getAutoTransferReports(ReportAutoTransferRequest request, BoomApi boomApi) {
        if (request == null) {
            request = ReportAutoTransferRequest.withoutFilter();
        }
        Asserts.notNull(boomApi, "BoomApi can't be null");
        String url = boomApi.baseUrl() + "deposits/transfer/auto/reports";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, AutoTransferReport.class);
    }

    public static BatchTransfer batchTransfer(BatchTransferRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "The request parameter can not be null");
        Asserts.notNull(boomApi, "The boomApi parameter can not be null");
        String url = boomApi.baseUrl() + "deposits/transfer/batch";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, BatchTransfer.class);
    }

    public static ListAutoTransfer getListAutoTransfer(ListAutoTransferRequest request, BoomApi boomApi) {
        if (request == null) {
            request = ListAutoTransferRequest.withoutFilter();
        }
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "deposits/transfer/auto/list";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, ListAutoTransfer.class);
    }
}

