/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.cards;

import ir.boommarket.cards.CardStatus;

public class CardListRequest {
    final String pan;
    final String depositNumber;
    final CardStatus cardStatus;
    final Long offset;
    final Long length;

    private CardListRequest(String pan, String depositNumber, CardStatus cardStatus, Long offset, Long length) {
        this.panNotEmpty(pan);
        this.depositNotEmpty(depositNumber);
        this.offsetNotNegative(offset);
        this.lengthNotNegative(length);
        this.pan = pan;
        this.depositNumber = depositNumber;
        this.cardStatus = cardStatus;
        this.offset = offset;
        this.length = length;
    }

    public static CardListRequest withoutFilter() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void depositNotEmpty(String depositNumber) {
        if (depositNumber != null && depositNumber.trim().isEmpty()) {
            throw new IllegalArgumentException("DepositNumber can't be a blank string");
        }
    }

    private void panNotEmpty(String pan) {
        if (pan != null && pan.trim().isEmpty()) {
            throw new IllegalArgumentException("Pan can't be a blank string");
        }
    }

    private void offsetNotNegative(Long offset) {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("Offset can't be a negative number");
        }
    }

    private void lengthNotNegative(Long length) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("Length can't be less than or equal to zero");
        }
    }

    public static class Builder {
        private String pan;
        private String depositNumber;
        private CardStatus cardStatus;
        private Long offset;
        private Long length;

        public Builder withPan(String pan) {
            this.pan = pan;
            return this;
        }

        public Builder withDepositNumber(String depositNumber) {
            this.depositNumber = depositNumber;
            return this;
        }

        public Builder withCardStatus(CardStatus cardStatus) {
            this.cardStatus = cardStatus;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder withLength(Long length) {
            this.length = length;
            return this;
        }

        public CardListRequest build() {
            return new CardListRequest(this.pan, this.depositNumber, this.cardStatus, this.offset, this.length);
        }
    }
}

