/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.ach;

import ir.boommarket.Asserts;
import java.math.BigDecimal;

public class AchDestinationTransaction {
    final String ibanNumber;
    final String ownerName;
    final BigDecimal amount;
    final String description;
    final String factorNumber;

    public AchDestinationTransaction(String ibanNumber, String ownerName, BigDecimal amount, String description, String factorNumber) {
        this.assertRequiredParams(ibanNumber, ownerName);
        this.assertAmountLimitation(amount);
        this.ibanNumber = ibanNumber;
        this.ownerName = ownerName;
        this.amount = amount;
        this.description = description;
        this.factorNumber = factorNumber;
    }

    public AchDestinationTransaction(String ibanNumber, String ownerName, BigDecimal amount) {
        this(ibanNumber, ownerName, amount, null, null);
    }

    private void assertRequiredParams(String ibanNumber, String ownerName) {
        Asserts.notBlank(ibanNumber, "Iban number can't be a blank string");
        Asserts.notBlank(ownerName, "owner name can't be a blank string");
    }

    private void assertAmountLimitation(BigDecimal amount) {
        if (amount == null || amount.signum() <= 0) {
            throw new IllegalArgumentException("Amount can't be null or negative");
        }
    }
}

