/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.deposits;

import java.math.BigDecimal;
import java.util.Date;

public class ListAutoTransferRequest {
    final String sourceDepositNumber;
    final String serial;
    final Date startDate;
    final Date endDate;
    final BigDecimal minAmount;
    final BigDecimal maxAmount;
    final Long offset;
    final Long length;

    private ListAutoTransferRequest(String sourceDepositNumber, String serial, Date startDate, Date endDate, BigDecimal minAmount, BigDecimal maxAmount, Long offset, Long length) {
        this.notZeroOrNegativeAmount(minAmount);
        this.notZeroOrNegativeAmount(maxAmount);
        this.notZeroOrNegative(length);
        this.notNegative(offset);
        this.sourceDepositNumber = sourceDepositNumber;
        this.serial = serial;
        this.startDate = startDate;
        this.endDate = endDate;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.offset = offset;
        this.length = length;
    }

    public static ListAutoTransferRequest withoutFilter() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void notNegative(Long offset) {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("offset can't be a negative number");
        }
    }

    private void notZeroOrNegative(Long length) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("length can't be less than or equal to zero");
        }
    }

    private void notZeroOrNegativeAmount(BigDecimal amount) {
        if (amount != null && amount.signum() <= 0) {
            throw new IllegalArgumentException("amount can't be a negative value");
        }
    }

    public static class Builder {
        private String sourceDepositNumber;
        private String serial;
        private Date startDate;
        private Date endDate;
        private BigDecimal minAmount;
        private BigDecimal maxAmount;
        private Long offset;
        private Long length;

        public Builder withSourceDepositNumber(String sourceDepositNumber) {
            this.sourceDepositNumber = sourceDepositNumber;
            return this;
        }

        public Builder withSerial(String serial) {
            this.serial = serial;
            return this;
        }

        public Builder withStartDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder withEndDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder withMinAmount(BigDecimal minAmount) {
            this.minAmount = minAmount;
            return this;
        }

        public Builder withMaxAmount(BigDecimal maxAmount) {
            this.maxAmount = maxAmount;
            return this;
        }

        public Builder withLength(Long length) {
            this.length = length;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public ListAutoTransferRequest build() {
            return new ListAutoTransferRequest(this.sourceDepositNumber, this.serial, this.startDate, this.endDate, this.minAmount, this.maxAmount, this.offset, this.length);
        }
    }
}

