/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.accounts;

import ir.boommarket.QueryParams;

public class AccountInfoRequest {
    final boolean hasAddress;
    final Long length;
    final Long offset;

    private AccountInfoRequest(boolean hasAddress, Long length, Long offset) {
        this.validatePaginationParameters(length, offset);
        this.hasAddress = hasAddress;
        this.length = length;
        this.offset = offset;
    }

    String toQueryParam() {
        return QueryParams.newQuery().with("has_address", this.hasAddress).with("length", this.length).with("offset", this.offset).toString();
    }

    public static AccountInfoRequest withoutAddress() {
        return AccountInfoRequest.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void validatePaginationParameters(Long length, Long offset) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("Length can't be less than or equal to zero");
        }
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("Offset can't be less than zero");
        }
    }

    public static class Builder {
        boolean hasAddress = false;
        Long length;
        Long offset;

        public Builder showAddresses() {
            this.hasAddress = true;
            return this;
        }

        public Builder withLength(Long length) {
            this.length = length;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public AccountInfoRequest build() {
            return new AccountInfoRequest(this.hasAddress, this.length, this.offset);
        }
    }
}

