/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryParams {
    private static final String EMPTY_QUERY_PARAM = "";
    private final Map<String, Object> keyValuePairs = new LinkedHashMap<String, Object>();

    private QueryParams() {
    }

    public static QueryParams newQuery() {
        return new QueryParams();
    }

    public QueryParams with(String key, Object value) {
        if (value != null) {
            this.keyValuePairs.put(key, value);
        }
        return this;
    }

    public String toString() {
        if (this.keyValuePairs.isEmpty()) {
            return EMPTY_QUERY_PARAM;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("?");
        int counter = 0;
        for (Map.Entry<String, Object> entry : this.keyValuePairs.entrySet()) {
            if (counter++ != 0) {
                builder.append("&");
            }
            builder.append(this.getUrlEncoded(entry.getKey()));
            builder.append("=");
            builder.append(this.getUrlEncoded(entry.getValue()));
        }
        return builder.toString();
    }

    private String getUrlEncoded(Object value) {
        try {
            return URLEncoder.encode(value.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }
}

