/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import ir.boommarket.JsonException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class Json {
    private static final ObjectMapper mapper = Json.getObjectMapper();
    private static final MediaType JSON_TYPE = MediaType.parse((String)"application/json;charset=UTF-8");

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"));
        mapper.setTimeZone(TimeZone.getTimeZone("UTC"));
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static RequestBody of(Object pojo) {
        try {
            return RequestBody.create((MediaType)JSON_TYPE, (String)mapper.writeValueAsString(pojo));
        }
        catch (JsonProcessingException e) {
            throw new JsonException("Couldn't generate a JSON string from " + pojo, e);
        }
    }

    public static <T> T read(String jsonStr, Class<T> clazz) {
        try {
            return (T)mapper.readValue(jsonStr, clazz);
        }
        catch (IOException e) {
            throw new JsonException("Couldn't map the " + jsonStr + " to the " + clazz + " type", e);
        }
    }
}

