package ir.afraapps.basic.module.calendar;

/**
 * @author Amir
 * @author ebraminio
 */
public class IslamicDate extends AbstractDate {

    private static final String[] monthName = {"", "محرم", "صفر",
            "ربيع‌الاول", "ربيع‌الثاني", "جمادي‌الاول", "جمادي‌الثاني", "رجب",
            "شعبان", "رمضان", "شوال", "ذي‌القعده", "ذي‌الحجه"};


    @Override
    public String[] getMonthsList() {
        return monthName;
    }

    private int day;
    private int month;
    private int year;


    public IslamicDate(int year, int month, int day) {
        setYear(year);
        // Initialize day, so that we get no exceptions when setting month
        this.day = 1;
        setMonth(month);
        setDayOfMonth(day);
    }


    @Override
    public int getDayOfMonth() {
        return day;
    }


    @Override
    public int getDayOfWeek() {
        throw new RuntimeException("not implemented yet!");
    }


    @Override
    public int getMonth() {
        return month;
    }


    @Override
    public String getMonthName() {
        return monthName[month];
    }


    @Override
    public int getWeekOfYear() {
        throw new RuntimeException("not implemented yet!");
    }


    @Override
    public int getYear() {
        return year;
    }


    @Override
    public void rollDay(int amount, boolean up) {
        throw new RuntimeException("not implemented yet!");
    }


    @Override
    public void rollMonth(int amount, boolean up) {
        throw new RuntimeException("not implemented yet!");
    }


    @Override
    public void rollYear(int amount, boolean up) {
        throw new RuntimeException("not implemented yet!");
    }


    @Override
    public void setDayOfMonth(int day) {
        // TODO This check is not very exact! But it's not worth of it
        // to compute the number of days in this month exactly
        if (day < 1 || day > 30)
            throw new DayOutOfRangeException("day " + day + " is out of range!");

        this.day = day;
    }


    @Override
    public void setMonth(int month) {
        if (month < 1 || month > 12)
            throw new MonthOutOfRangeException("month " + month
                    + " is out of range!");

        // Set the day again, so that exceptions are thrown if the
        // day is out of range
        setDayOfMonth(day);

        this.month = month;
    }


    @Override
    public void setYear(int year) {
        if (year == 0)
            throw new YearOutOfRangeException("Year 0 is invalid!");

        this.year = year;
    }


    @Override
    public String getEvent() {
        throw new RuntimeException("not implemented yet!");
    }


    @Override
    public int getDayOfYear() {
        throw new RuntimeException("not implemented yet!");
    }


    @Override
    public int getWeekOfMonth() {
        throw new RuntimeException("not implemented yet!");
    }


    @Override
    public boolean isLeapYear() {
        throw new RuntimeException("not implemented yet!");
    }

}
