package ir.afraapps.basic.view.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.ColorInt;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;
import android.support.v7.view.ContextThemeWrapper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import ir.afraapps.basic.R;
import ir.afraapps.basic.helper.UText;


/**
 * In the name of Allah
 * <p>
 * Created by ali on 11/3/17.
 */

public class UAlertDialog implements DialogInterface.OnClickListener {

  private AlertDialog dialog;
  private Context context;

  private String title;
  private String message;
  private String messageHtml;
  private String positiveLabel;
  private String negativeLabel;

  private int titleColor;
  private int messageColor;
  private int positiveColor;
  private int negativeColor;

  private boolean darkTheme;
  private boolean cancelable;

  private Runnable action;
  private Runnable actionDismiss;
  private Runnable actionCancel;

  public UAlertDialog(Context context) {
    this.context = context;
  }

  public void show() {
    if (dialog != null && dialog.isShowing()) {
      dialog.dismiss();
    }

    if (TextUtils.isEmpty(positiveLabel)) {
      positiveLabel = context.getString(R.string.ok);
    }

    /*if (TextUtils.isEmpty(negativeLabel)) {
      negativeLabel = context.getString(R.string.cancel);
    }*/

    if (darkTheme) {
      context = getDarkThemeContext();
    }

    AlertDialog.Builder builder = new AlertDialog.Builder(context);

    builder.setPositiveButton(positiveLabel, this);
    builder.setNegativeButton(negativeLabel, this);

    @SuppressLint("InflateParams")
    View content = LayoutInflater.from(context).inflate(R.layout.dialog_alert_layout, null);
    TextView txtTitle = content.findViewById(R.id.title);
    TextView txtMessage = content.findViewById(R.id.message);

    if (titleColor != 0) {
      txtTitle.setTextColor(titleColor);
    }

    if (messageColor != 0) {
      txtMessage.setTextColor(messageColor);
    }

    txtTitle.setText(title);

    if (messageHtml != null) {
      txtMessage.setText(UText.fromHtml(messageHtml));

    } else {
      txtMessage.setText(message);
    }


    builder.setView(content);

    dialog = builder.create();
    dialog.setCancelable(cancelable);
    if (actionDismiss != null) {
      dialog.setOnDismissListener(dialog -> actionDismiss.run());
    }

    dialog.show();

    if (positiveColor != 0) {
      dialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(positiveColor);
    }

    if (negativeColor != 0) {
      dialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(negativeColor);
    }

    // UTypeface.changeViewFont(dialog.getButton(AlertDialog.BUTTON_POSITIVE), positiveColor);
    // UTypeface.changeViewFont(dialog.getButton(AlertDialog.BUTTON_NEGATIVE), negativeColor);
  }

  @SuppressLint("RestrictedApi")
  private Context getDarkThemeContext() {
    return new ContextThemeWrapper(context, R.style.AlertDialogDarkTheme);
  }


  public UAlertDialog setTitle(String title) {
    this.title = title;
    return this;
  }

  public UAlertDialog setTitle(@StringRes int titleRes) {
    this.title = context.getString(titleRes);
    return this;
  }

  public UAlertDialog setMessage(String message) {
    this.message = message;
    return this;
  }

  public UAlertDialog setMessage(@StringRes int messageRes) {
    this.message = context.getString(messageRes);
    return this;
  }

  public UAlertDialog setMessageHtml(String message) {
    this.messageHtml = message;
    return this;
  }

  public UAlertDialog setMessageHtml(@StringRes int messageRes) {
    this.messageHtml = context.getString(messageRes);
    return this;
  }

  public UAlertDialog setPositiveLabel(String positiveLabel) {
    this.positiveLabel = positiveLabel;
    return this;
  }

  public UAlertDialog setPositiveLabel(@StringRes int positiveLabelRes) {
    this.positiveLabel = context.getString(positiveLabelRes);
    return this;
  }

  public UAlertDialog setNegativeLabel(String negativeLabel) {
    this.negativeLabel = negativeLabel;
    return this;
  }

  public UAlertDialog setNegativeLabel(@StringRes int negativeLabelRes) {
    this.negativeLabel = context.getString(negativeLabelRes);
    return this;
  }

  public UAlertDialog setTitleColor(@ColorInt int titleColor) {
    this.titleColor = titleColor;
    return this;
  }

  public UAlertDialog setMessageColor(@ColorInt int messageColor) {
    this.messageColor = messageColor;
    return this;
  }

  public UAlertDialog setPositiveColor(@ColorInt int positiveColor) {
    this.positiveColor = positiveColor;
    return this;
  }

  public UAlertDialog setNegativeColor(@ColorInt int negativeColor) {
    this.negativeColor = negativeColor;
    return this;
  }

  public UAlertDialog setCancelable(boolean cancelable) {
    this.cancelable = cancelable;
    return this;
  }

  public UAlertDialog setAction(Runnable action) {
    this.action = action;
    return this;
  }


  public UAlertDialog setDismissAction(Runnable actionDismiss) {
    this.actionDismiss = actionDismiss;
    return this;
  }


  public UAlertDialog setCancelAction(Runnable actionCancel) {
    this.actionCancel = actionCancel;
    return this;
  }


  public UAlertDialog useDarkTheme() {
    this.darkTheme = true;
    return this;
  }


  @Override
  public void onClick(DialogInterface dialog, int which) {
    switch (which) {
      case DialogInterface.BUTTON_POSITIVE:
        dialog.dismiss();
        if (action != null) action.run();
        break;

      case DialogInterface.BUTTON_NEGATIVE:
        dialog.dismiss();
        if (actionCancel != null) actionCancel.run();
        break;
    }
  }
}
