/*
 * Decompiled with CFR 0.152.
 */
package in.findcode.flexseleniumdriver;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class FlexBaseDriver {
    protected static WebDriver webDriver;
    protected static String flashObjectId;

    protected String call(String functionName, String ... args) {
        Object result = ((JavascriptExecutor)webDriver).executeScript(this.makeJsFunction(functionName, args), new Object[0]);
        return result != null ? result.toString() : null;
    }

    private String makeJsFunction(String functionName, String ... args) {
        StringBuffer functionArgs = new StringBuffer();
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    functionArgs.append(",");
                }
                functionArgs.append(String.format("'%1$s'", args[i]));
            }
        }
        return String.format("return document.%1$s.%2$s(%3$s);", flashObjectId, functionName, functionArgs);
    }

    public String click(String objectId, String optionalButtonLabel) {
        return this.call("doFlexClick", objectId, optionalButtonLabel);
    }

    public String click(String objectId) {
        return this.click(objectId, "");
    }

    public String getText(String textFieldId) {
        return this.call("getFlexText", textFieldId, "");
    }

    public boolean isEnabled(String objectId) {
        String state = this.call("getFlexEnabled", objectId, "");
        if (!"true".equals(state) && !"false".equals(state)) {
            System.out.println(String.format("Enabled state of '%s' returned an unexpected value: %s", objectId, state));
        }
        return Boolean.parseBoolean(state);
    }

    public int getNumSelectedItems(String objectId) {
        return Integer.parseInt(this.call("getFlexNumSelectedItems", objectId, ""));
    }

    public String getSelectedItemAtIndex(String objectId, int index) {
        return this.call("getFlexSelectedItemAtIndex", objectId, Integer.toString(index));
    }

    public boolean exists(String objectId) {
        return Boolean.parseBoolean(this.call("getFlexExists", objectId, ""));
    }

    public String getErrorString(String textFieldId) {
        return this.call("getFlexErrorString", textFieldId, "");
    }

    public String selectMatchingOnField(String selectionFieldId, String underlyingField, String underlyingValue) {
        return this.call("doFlexSelectMatchingOnField", selectionFieldId, underlyingField, underlyingValue);
    }

    public String addSelectMatchingOnField(String selectionFieldId, String underlyingField, String underlyingValue) {
        return this.call("doFlexAddSelectMatchingOnField", selectionFieldId, underlyingField, underlyingValue);
    }

    public void selectIndex(String selectionFieldId, int index) {
        this.call("doFlexSelectIndex", selectionFieldId, Integer.toString(index));
    }

    public String getProperty(String objectId, String property) {
        return this.call("getFlexProperty", objectId, property);
    }

    public String getFlexComponent(String objectId) {
        return this.call("getFlexComponent", objectId);
    }

    public String getFlexComponentChildren(String objectId) {
        return this.call("getFlexComponentChildren", objectId);
    }

    public String getFlexFullDeepComponentTree(String objectId) {
        return this.call("getFlexFullDeepComponentTree", objectId);
    }

    public String getFlexComponentProperties(String objectId) {
        return this.call("getFlexComponentProperties", objectId);
    }

    public String select(String objectId, String optionalButtonLabel) {
        return this.call("doFlexSelect", objectId, optionalButtonLabel);
    }

    public String select(String objectId) {
        return this.select(objectId, "");
    }

    public String doubleClick(String objectId, String optionalButtonLabel) {
        return this.call("doFlexDoubleClick", objectId, optionalButtonLabel);
    }

    public String doubleClick(String objectId) {
        return this.doubleClick(objectId, "");
    }

    public String setFocus(String objectId, String optionalButtonLabel) {
        return this.call("doFlexSetFocus", objectId, optionalButtonLabel);
    }

    public String setFocus(String objectId) {
        return this.setFocus(objectId, "");
    }

    public String type(String objectId, String text) {
        return this.call("doFlexType", objectId, text);
    }

    public String mouseMove(String objectId, String optionalButtonLabel) {
        return this.call("doFlexMouseMove", objectId, optionalButtonLabel);
    }

    public String mouseEvent(String objectId, String event) {
        return this.call("doFlexMouseEvent", objectId, event);
    }

    public String mouseEvent(String objectId, String event, String positionX, String positionY) {
        return this.call("doFlexMouseEventOnPosition", objectId, event, positionX, positionY);
    }

    public String mouseMove(String objectId) {
        return this.mouseMove(objectId, "");
    }

    public int getSelectionIndex(String selectionFieldId) {
        return Integer.parseInt(this.call("getFlexSelectionIndex", selectionFieldId, ""));
    }

    public boolean isVisible(String objectId) {
        String result = this.call("getFlexVisible", objectId, "");
        if (!"true".equals(result) && !"false".equals(result)) {
            System.out.println(String.format("Visibility of '%s' returned an unexpected value: %s", objectId, result));
        }
        return Boolean.parseBoolean(result);
    }

    public String getFlexTextPresent(String objectId, String searchText) {
        return this.call("getFlexTextPresent", objectId, searchText);
    }

    public String getFlexStepper(String objectId) {
        return this.call("getFlexStepper", objectId, null);
    }

    public String isRadioButtonSelected(String objectId) {
        return this.call("getFlexRadioButton", objectId, null);
    }

    public String getFlexParseInt(String objectId, String property) {
        return this.call("getFlexParseInt", objectId, property);
    }

    public String getFlexNumeric(String objectId, String regtext) {
        return this.call("getFlexNumeric", objectId, regtext);
    }

    public String getFlexGlobalPosition(String objectId) {
        return this.call("getFlexGlobalPosition", objectId);
    }

    public String getFlexComponentInfo(String objectId) {
        return this.call("getFlexComponentInfo", objectId);
    }

    public String doFlexProperty(String objectId, String value) {
        return this.call("doFlexProperty", objectId, value);
    }
}

