/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package in.findcode.flexseleniumdriver.component;

import in.findcode.flexseleniumdriver.FlexBaseDriver;
import in.findcode.flexseleniumdriver.common.Constants;

/**
 *
 * @author Uttesh Kumar T.H.
 */
public class DataGrid extends FlexBaseDriver {

    public String clickItem(final String objectId, final String label) {
        return call(Constants.JSFunction.CLICK_DATA_GRID_ITEM_FN, objectId, label);
    }

    public String clickItem(final String objectId) {
        return call(Constants.JSFunction.CLICK_FN, objectId, Constants.EMPTY_STRING);
    }

    public String clickComponent(final String objectId, final String label) {
        return call(Constants.JSFunction.CLICK_DATA_GRID_FN, objectId, label);
    }

    public String clickComponent(final String objectId) {
        return clickComponent(objectId, Constants.EMPTY_STRING);
    }

    public String getDataFieldLabelForRow(
            String dataGridId, String field, int row) {
        return call(Constants.JSFunction.GET_DATAGRID_FIELD_LABEL_FOR_GRIDROW, dataGridId, field, Integer.toString(row));
    }

    public int getRowCount(String dataGridId) {
        return Integer.parseInt(call(Constants.JSFunction.GET_DATAGRID_ROW_COUNT, dataGridId));
    }

    public String getValue(String dataGridId, int row, int col) {
        return call(Constants.JSFunction.GET_DATAGRID_CELL, dataGridId, Integer.toString(row), Integer.toString(col));
    }

    public int getRowIndexForFieldValue(String dataGridId, String field, String value) {
        return Integer.parseInt(call(Constants.JSFunction.GET_DATAGRID_ROW_INDEX_FOR_FIELD_VALUE, dataGridId, field, value));
    }

    public int getRowIndexForFieldLabel(String dataGridId, String field, String label) {
        return Integer.parseInt(call(Constants.JSFunction.GET_DATAGRID_ROW_INDEX_FOR_FIELD_LABEL, dataGridId, field, label));
    }

    public String getFieldValueForRow(
            String dataGridId, String field, int row) {
        return call(Constants.JSFunction.GET_DATAGRID_FIELD_VALUE_FOR_GRID_ROW, dataGridId, field, Integer.toString(row));
    }

}
