/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package in.findcode.flexseleniumdriver;

import in.findcode.flexseleniumdriver.common.Constants;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

/**
 *
 * @author Uttesh Kumar T.H.
 */
public class FlexBaseDriver {

    protected static WebDriver webDriver;
    protected static String flashObjectId;

    protected String call(final String functionName, final String... args) {
        final Object result
                = ((JavascriptExecutor) webDriver).executeScript(
                        makeJsFunction(functionName, args),
                        new Object[0]);

        return result != null ? result.toString() : null;
    }

    private String makeJsFunction(final String functionName, final String... args) {
        final StringBuffer functionArgs = new StringBuffer();

        if (args.length > 0) {
            for (int i = 0; i < args.length; i++) {
                if (i > 0) {
                    functionArgs.append(",");
                }
                functionArgs.append(String.format("'%1$s'", args[i]));
            }
        }
        return String.format(
                "return document.%1$s.%2$s(%3$s);",
                flashObjectId,
                functionName,
                functionArgs);
    }

    public String click(final String objectId, final String optionalButtonLabel) {
        return call(Constants.JSFunction.CLICK_FN, objectId, optionalButtonLabel);
    }

    public String click(final String objectId) {
        return click(objectId, Constants.EMPTY_STRING);
    }

    public String getText(String textFieldId) {
        return call(Constants.JSFunction.GET_TEXT, textFieldId, Constants.EMPTY_STRING);
    }

    public boolean isEnabled(String objectId) {
        final String state = call(Constants.JSFunction.GET_ENABLED, objectId, Constants.EMPTY_STRING);
        if (!"true".equals(state) && !"false".equals(state)) {
            System.out.println(String.format("Enabled state of '%s' returned an unexpected value: %s", objectId, state));
        }
        return Boolean.parseBoolean(state);
    }

    public int getNumSelectedItems(String objectId) {
        return Integer.parseInt(call(Constants.JSFunction.GET_NUM_SELECTED_ITEMS, objectId, Constants.EMPTY_STRING));
    }

    public String getSelectedItemAtIndex(String objectId, int index) {
        return call(Constants.JSFunction.GET_SELECTED_ITEM_AT_INDEX, objectId, Integer.toString(index));
    }

    public boolean exists(String objectId) {
        return Boolean.parseBoolean(call(Constants.JSFunction.GET_EXISTS, objectId, Constants.EMPTY_STRING));
    }

    public String getErrorString(String textFieldId) {
        return call(Constants.JSFunction.GET_ERROR_STRING, textFieldId, Constants.EMPTY_STRING);
    }

    public String selectMatchingOnField(String selectionFieldId, String underlyingField, String underlyingValue) {
        return call(Constants.JSFunction.SELECT_MATCHING_ON_FIELD, selectionFieldId, underlyingField, underlyingValue);
    }

    public String addSelectMatchingOnField(String selectionFieldId, String underlyingField, String underlyingValue) {
        return call(Constants.JSFunction.ADD_SELECT_MATCHING_ON_FIELD, selectionFieldId, underlyingField, underlyingValue);

    }

    public void selectIndex(String selectionFieldId, int index) {
        call(Constants.JSFunction.SELECT_INDEX, selectionFieldId, Integer.toString(index));
    }

    public String getProperty(String objectId, String property) {
        return call(Constants.JSFunction.GET_PROPERTY, objectId, property);
    }

    public String select(final String objectId, final String optionalButtonLabel) {
        return call(Constants.JSFunction.SELECT_FN, objectId, optionalButtonLabel);
    }

    public String select(final String objectId) {
        return select(objectId, Constants.EMPTY_STRING);
    }

    public String doubleClick(final String objectId, final String optionalButtonLabel) {
        return call(Constants.JSFunction.DOUBLE_CLICK_FN, objectId, optionalButtonLabel);
    }

    public String doubleClick(final String objectId) {
        return doubleClick(objectId, Constants.EMPTY_STRING);
    }

    public String setFocus(final String objectId, final String optionalButtonLabel) {
        return call(Constants.JSFunction.SET_FOCUS, objectId, optionalButtonLabel);
    }

    public String setFocus(final String objectId) {
        return setFocus(objectId, Constants.EMPTY_STRING);
    }

    public String type(final String objectId, final String text) {
        return call(Constants.JSFunction.TYPE, objectId, text);
    }

    public String mouseMove(final String objectId, final String optionalButtonLabel) {
        return call(Constants.JSFunction.MOUSE_MOVE, objectId, optionalButtonLabel);
    }

    public String mouseMove(final String objectId) {
        return mouseMove(objectId, Constants.EMPTY_STRING);
    }

    public int getSelectionIndex(String selectionFieldId) {
        return Integer.parseInt(call(Constants.JSFunction.GET_SELECTION_INDEX, selectionFieldId, Constants.EMPTY_STRING));
    }

    public boolean isVisible(String objectId) {
        final String result = call(Constants.JSFunction.GET_VISIBLE, objectId, Constants.EMPTY_STRING);
        if (!"true".equals(result) && !"false".equals(result)) {
            System.out.println(String.format("Visibility of '%s' returned an unexpected value: %s", objectId, result));
        }
        return Boolean.parseBoolean(result);
    }
}
