/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler.sockjs;

import com.codahale.metrics.Meter;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.Handler;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEvent;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEventContext;
import io.vertx.reactivex.ext.web.handler.sockjs.processor.BridgeEventProcessor;
import java.util.UUID;
import org.apache.logging.log4j.Logger;

public class BridgeEventHandler
implements Handler<BridgeEvent> {
    private Logger mLog;
    private BridgeEventProcessor[] mPublishProcessors;
    private BridgeEventProcessor[] mReceiveProcessors;
    private BridgeEventProcessor[] mRegisterProcessors;
    private BridgeEventProcessor[] mSendProcessors;
    private BridgeEventProcessor[] mSocketClosedProcessors;
    private BridgeEventProcessor[] mSocketCreatedProcessors;
    private BridgeEventProcessor[] mSocketIdleProcessors;
    private BridgeEventProcessor[] mSoketPingProcessors;
    private BridgeEventProcessor[] mUnregisterProcessors;
    private Meter mMetricsBridgeEventSend;
    private Meter mMetricsBridgeEventPublish;
    private Meter mMetricsBridgeEventReceive;
    private Meter mMetricsBridgeEventRegister;
    private Meter mMetricsBridgeEventUnregister;

    public void handle(BridgeEvent pEvent) {
        switch (pEvent.type()) {
            case PUBLISH: {
                this.getMetricsBridgeEventPublish().mark();
                this.process(this.getPublishProcessors(), pEvent);
                break;
            }
            case RECEIVE: {
                this.getMetricsBridgeEventReceive().mark();
                this.process(this.getReceiveProcessors(), pEvent);
                break;
            }
            case REGISTER: {
                this.getMetricsBridgeEventRegister().mark();
                this.process(this.getRegisterProcessors(), pEvent);
                break;
            }
            case SEND: {
                this.getMetricsBridgeEventSend().mark();
                this.process(this.getSendProcessors(), pEvent);
                break;
            }
            case SOCKET_CLOSED: {
                this.process(this.getSocketClosedProcessors(), pEvent);
                break;
            }
            case SOCKET_CREATED: {
                this.process(this.getSocketCreatedProcessors(), pEvent);
                break;
            }
            case SOCKET_IDLE: {
                this.process(this.getSocketIdleProcessors(), pEvent);
                break;
            }
            case SOCKET_PING: {
                this.process(this.getSoketPingProcessors(), pEvent);
                break;
            }
            case UNREGISTER: {
                this.getMetricsBridgeEventUnregister().mark();
                this.process(this.getUnregisterProcessors(), pEvent);
            }
        }
    }

    protected void process(BridgeEventProcessor[] pProcessors, BridgeEvent pEvent) {
        if (pProcessors == null || pProcessors.length == 0) {
            pEvent.complete(Boolean.valueOf(true));
            return;
        }
        BridgeEventContext ctx = new BridgeEventContext();
        ctx.setBridgeEvent(pEvent);
        if (this.getLog().isDebugEnabled()) {
            ctx.setId(UUID.randomUUID().toString());
        }
        Observable.fromArray((Object[])pProcessors).reduce((Object)Single.just((Object)ctx), (acc, processor) -> processor.process((Single<BridgeEventContext>)acc)).flatMap(context -> context).doFinally(() -> {
            if (ctx.getBridgeEvent().future().failed()) {
                this.getLog().debug(() -> String.format("[%s] BridgeEvent Failed: [%s]", ctx.getId(), ctx.getBridgeEvent().getRawMessage()));
                return;
            }
            this.getLog().debug(() -> String.format("[%s] BridgeEvent Success [%s]", ctx.getId(), ctx.getBridgeEvent().getRawMessage()));
            ctx.getBridgeEvent().complete(Boolean.valueOf(true));
        }).subscribe();
    }

    public BridgeEventProcessor[] getPublishProcessors() {
        return this.mPublishProcessors;
    }

    public void setPublishProcessors(BridgeEventProcessor[] pPublishProcessors) {
        this.mPublishProcessors = pPublishProcessors;
    }

    public BridgeEventProcessor[] getReceiveProcessors() {
        return this.mReceiveProcessors;
    }

    public void setReceiveProcessors(BridgeEventProcessor[] pReceiveProcessors) {
        this.mReceiveProcessors = pReceiveProcessors;
    }

    public BridgeEventProcessor[] getRegisterProcessors() {
        return this.mRegisterProcessors;
    }

    public void setRegisterProcessors(BridgeEventProcessor[] pRegisterProcessors) {
        this.mRegisterProcessors = pRegisterProcessors;
    }

    public BridgeEventProcessor[] getSendProcessors() {
        return this.mSendProcessors;
    }

    public void setSendProcessors(BridgeEventProcessor[] pSendProcessors) {
        this.mSendProcessors = pSendProcessors;
    }

    public BridgeEventProcessor[] getSocketClosedProcessors() {
        return this.mSocketClosedProcessors;
    }

    public void setSocketClosedProcessors(BridgeEventProcessor[] pSocketClosedProcessors) {
        this.mSocketClosedProcessors = pSocketClosedProcessors;
    }

    public BridgeEventProcessor[] getSocketCreatedProcessors() {
        return this.mSocketCreatedProcessors;
    }

    public void setSocketCreatedProcessors(BridgeEventProcessor[] pSocketCreatedProcessors) {
        this.mSocketCreatedProcessors = pSocketCreatedProcessors;
    }

    public BridgeEventProcessor[] getSocketIdleProcessors() {
        return this.mSocketIdleProcessors;
    }

    public void setSocketIdleProcessors(BridgeEventProcessor[] pSocketIdleProcessors) {
        this.mSocketIdleProcessors = pSocketIdleProcessors;
    }

    public BridgeEventProcessor[] getSoketPingProcessors() {
        return this.mSoketPingProcessors;
    }

    public void setSoketPingProcessors(BridgeEventProcessor[] pSoketPingProcessors) {
        this.mSoketPingProcessors = pSoketPingProcessors;
    }

    public BridgeEventProcessor[] getUnregisterProcessors() {
        return this.mUnregisterProcessors;
    }

    public void setUnregisterProcessors(BridgeEventProcessor[] pUnregisterProcessors) {
        this.mUnregisterProcessors = pUnregisterProcessors;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public Meter getMetricsBridgeEventSend() {
        return this.mMetricsBridgeEventSend;
    }

    public void setMetricsBridgeEventSend(Meter pMetricsBridgeEventSend) {
        this.mMetricsBridgeEventSend = pMetricsBridgeEventSend;
    }

    public Meter getMetricsBridgeEventPublish() {
        return this.mMetricsBridgeEventPublish;
    }

    public void setMetricsBridgeEventPublish(Meter pMetricsBridgeEventPublish) {
        this.mMetricsBridgeEventPublish = pMetricsBridgeEventPublish;
    }

    public Meter getMetricsBridgeEventReceive() {
        return this.mMetricsBridgeEventReceive;
    }

    public void setMetricsBridgeEventReceive(Meter pMetricsBridgeEventReceive) {
        this.mMetricsBridgeEventReceive = pMetricsBridgeEventReceive;
    }

    public Meter getMetricsBridgeEventRegister() {
        return this.mMetricsBridgeEventRegister;
    }

    public void setMetricsBridgeEventRegister(Meter pMetricsBridgeEventRegister) {
        this.mMetricsBridgeEventRegister = pMetricsBridgeEventRegister;
    }

    public Meter getMetricsBridgeEventUnregister() {
        return this.mMetricsBridgeEventUnregister;
    }

    public void setMetricsBridgeEventUnregister(Meter pMetricsBridgeEventUnregister) {
        this.mMetricsBridgeEventUnregister = pMetricsBridgeEventUnregister;
    }
}

