/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import in.erail.glue.annotation.StartService;
import io.reactivex.plugins.RxJavaPlugins;
import io.vertx.core.VertxOptions;
import io.vertx.reactivex.core.RxHelper;
import io.vertx.reactivex.core.Vertx;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.Logger;

public class VertxInstance {
    private Logger mLog;
    private VertxOptions mVertxOptions;
    private final CompletableFuture<Vertx> mVertx = new CompletableFuture();

    @StartService
    public void start() {
        if (this.getVertxOptions().getEventBusOptions().isClustered()) {
            this.getLog().info(() -> "Starting Vertx in Cluster Mode");
            Vertx.rxClusteredVertx((VertxOptions)this.getVertxOptions()).doOnSuccess(v -> this.getLog().info(() -> "Vertx is running in cluster mode")).subscribe(t -> this.mVertx.complete((Vertx)t));
        } else {
            this.getLog().info(() -> "Starting Vertx in Cluster Mode");
            this.mVertx.complete(Vertx.vertx((VertxOptions)this.getVertxOptions()));
        }
    }

    public Vertx create() throws InterruptedException, ExecutionException {
        Vertx v = this.mVertx.get();
        RxJavaPlugins.setComputationSchedulerHandler(s -> RxHelper.scheduler((Vertx)v));
        RxJavaPlugins.setIoSchedulerHandler(s -> RxHelper.blockingScheduler((Vertx)v));
        RxJavaPlugins.setNewThreadSchedulerHandler(s -> RxHelper.scheduler((Vertx)v));
        return v;
    }

    public VertxOptions getVertxOptions() {
        return this.mVertxOptions;
    }

    public void setVertxOptions(VertxOptions pVertxOptions) {
        this.mVertxOptions = pVertxOptions;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }
}

