/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler.sockjs.processor;

import com.google.common.base.Strings;
import io.reactivex.Single;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEventContext;
import io.vertx.reactivex.ext.web.handler.sockjs.processor.BridgeEventProcessor;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class AllowedTopicRegistrationProcessor
implements BridgeEventProcessor {
    private Logger mLog;
    private List<String> mAddressAllowedToRegister;
    private List<String> mAddressAllowedToRegisterRegex;

    private boolean matchAddress(String pAddress) {
        return this.mAddressAllowedToRegister.stream().anyMatch(allowedAddress -> pAddress.equals(allowedAddress));
    }

    private boolean matchAddressRegex(String pAddress) {
        return this.mAddressAllowedToRegisterRegex.stream().anyMatch(allowedAddress -> pAddress.matches((String)allowedAddress));
    }

    public List<String> getAddressAllowedToRegister() {
        return this.mAddressAllowedToRegister;
    }

    public void setAddressAllowedToRegister(List<String> pAddressAllowedToRegister) {
        this.mAddressAllowedToRegister = pAddressAllowedToRegister;
    }

    public List<String> getAddressAllowedToRegisterRegex() {
        return this.mAddressAllowedToRegisterRegex;
    }

    public void setAddressAllowedToRegisterRegex(List<String> pAddressAllowedToRegisterRegex) {
        this.mAddressAllowedToRegisterRegex = pAddressAllowedToRegisterRegex;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    @Override
    public Single<BridgeEventContext> process(Single<BridgeEventContext> pContext) {
        return pContext.map(ctx -> {
            if (ctx.getBridgeEvent().failed()) {
                return ctx;
            }
            if (this.mAddressAllowedToRegister.isEmpty() && this.mAddressAllowedToRegisterRegex.isEmpty()) {
                this.getLog().debug(() -> String.format("[%s] No Access Restriction", ctx.getId() != null ? ctx.getId() : ""));
                return ctx;
            }
            if (Strings.isNullOrEmpty((String)ctx.getAddress())) {
                this.getLog().error(() -> String.format("[%s] Address can't empty", ctx.getId() != null ? ctx.getId() : ""));
                return ctx;
            }
            if (!this.matchAddress(ctx.getAddress()) && !this.matchAddressRegex(ctx.getAddress())) {
                this.getLog().debug(() -> String.format("[%s] Registration failed:[%s]", ctx.getId(), ctx.getAddress()));
                ctx.getBridgeEvent().fail("Can't subscribe to topic : " + ctx.getAddress());
            } else {
                this.getLog().debug(() -> String.format("[%s] Registration Allowed:[%s]", ctx.getId(), ctx.getAddress()));
            }
            return ctx;
        });
    }
}

