/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.auth.oauth2.providers;

import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth;
import io.vertx.reactivex.ext.auth.oauth2.providers.OpenIDConnectAuth;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Logger;

public class OpenIDConnectAuthFactory {
    private Vertx mVertx;
    private OAuth2Auth mAuthProvider;
    private Class<? extends OpenIDConnectAuth> mOpenIDConnectAuthClass;
    private OAuth2ClientOptions mOAuth2ClientOptions;
    private Logger mLog;

    public OAuth2Auth create() throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.mAuthProvider == null) {
            Method m = this.getOpenIDConnectAuthClass().getMethod("rxDiscover", Vertx.class, OAuth2ClientOptions.class);
            Single auth = (Single)m.invoke(null, this.getVertx(), this.getOAuth2ClientOptions());
            this.mAuthProvider = (OAuth2Auth)auth.subscribeOn(Schedulers.io()).doOnSuccess(a -> this.getLog().debug(() -> "AuthProvider Created Successfully")).blockingGet();
        }
        return this.mAuthProvider;
    }

    public Vertx getVertx() {
        return this.mVertx;
    }

    public void setVertx(Vertx pVertx) {
        this.mVertx = pVertx;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public Class<? extends OpenIDConnectAuth> getOpenIDConnectAuthClass() {
        return this.mOpenIDConnectAuthClass;
    }

    public void setOpenIDConnectAuthClass(Class<? extends OpenIDConnectAuth> pOpenIDConnectAuthClass) {
        this.mOpenIDConnectAuthClass = pOpenIDConnectAuthClass;
    }

    public OAuth2ClientOptions getOAuth2ClientOptions() {
        return this.mOAuth2ClientOptions;
    }

    public void setOAuth2ClientOptions(OAuth2ClientOptions pOAuth2ClientOptions) {
        this.mOAuth2ClientOptions = pOAuth2ClientOptions;
    }
}

