/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import in.erail.glue.annotation.StartService;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.handler.sockjs.BridgeOptions;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class BridgeOptionsExt
extends BridgeOptions {
    private Logger mLog;
    private List<String> mInboundAddress;
    private List<String> mOutboundAddress;
    private List<String> mInboundAddressRegex;
    private List<String> mOutboundAddressRegex;
    private List<String> mInboundRequiredAuthority;
    private List<String> mOutboundRequiredAuthority;

    @StartService
    public void start() {
        this.getLog().debug(() -> MoreObjects.toStringHelper((String)BridgeOptionsExt.class.getCanonicalName()).add("InboundAddress", (Object)Joiner.on((String)",").join(this.mInboundAddress)).add("OutboundAddress", (Object)Joiner.on((String)",").join(this.mOutboundAddress)).add("InboundAddressRegex", (Object)Joiner.on((String)",").join(this.mInboundAddressRegex)).add("OutboundAddressRegex", (Object)Joiner.on((String)",").join(this.mOutboundAddressRegex)).add("InboundRequiredAuthority", (Object)Joiner.on((String)",").join(this.mInboundRequiredAuthority)).add("OutboundRequiredAuthority", (Object)Joiner.on((String)",").join(this.mOutboundRequiredAuthority)).toString());
        this.getInboundAddress().stream().forEachOrdered(rule -> {
            PermittedOptions option = new PermittedOptions();
            option.setAddress(rule);
            this.addInboundPermitted(option);
        });
        this.getOutboundAddress().stream().forEachOrdered(rule -> {
            PermittedOptions option = new PermittedOptions();
            option.setAddress(rule);
            this.addOutboundPermitted(option);
        });
        this.getInboundAddressRegex().stream().forEachOrdered(rule -> {
            PermittedOptions option = new PermittedOptions();
            option.setAddressRegex(rule);
            this.addInboundPermitted(option);
        });
        this.getOutboundAddressRegex().stream().forEachOrdered(rule -> {
            PermittedOptions option = new PermittedOptions();
            option.setAddressRegex(rule);
            this.addOutboundPermitted(option);
        });
        this.getInboundRequiredAuthority().stream().forEachOrdered(rule -> {
            PermittedOptions option = new PermittedOptions();
            option.setRequiredAuthority(rule);
            this.addInboundPermitted(option);
        });
        this.getOutboundRequiredAuthority().stream().forEachOrdered(rule -> {
            PermittedOptions option = new PermittedOptions();
            option.setRequiredAuthority(rule);
            this.addOutboundPermitted(option);
        });
    }

    public List<String> getInboundAddress() {
        return this.mInboundAddress;
    }

    public void setInboundAddress(List<String> pInboundAddress) {
        this.mInboundAddress = pInboundAddress;
    }

    public List<String> getOutboundAddress() {
        return this.mOutboundAddress;
    }

    public void setOutboundAddress(List<String> pOutboundAddress) {
        this.mOutboundAddress = pOutboundAddress;
    }

    public List<String> getInboundAddressRegex() {
        return this.mInboundAddressRegex;
    }

    public void setInboundAddressRegex(List<String> pInboundAddressRegex) {
        this.mInboundAddressRegex = pInboundAddressRegex;
    }

    public List<String> getOutboundAddressRegex() {
        return this.mOutboundAddressRegex;
    }

    public void setOutboundAddressRegex(List<String> pOutboundAddressRegex) {
        this.mOutboundAddressRegex = pOutboundAddressRegex;
    }

    public List<String> getInboundRequiredAuthority() {
        return this.mInboundRequiredAuthority;
    }

    public void setInboundRequiredAuthority(List<String> pInboundRequiredAuthority) {
        this.mInboundRequiredAuthority = pInboundRequiredAuthority;
    }

    public List<String> getOutboundRequiredAuthority() {
        return this.mOutboundRequiredAuthority;
    }

    public void setOutboundRequiredAuthority(List<String> pOutboundRequiredAuthority) {
        this.mOutboundRequiredAuthority = pOutboundRequiredAuthority;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }
}

