/*
 * Decompiled with CFR 0.152.
 */
package in.erail.route;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import in.erail.glue.annotation.StartService;
import in.erail.model.RequestEvent;
import in.erail.model.ResponseEvent;
import in.erail.route.AbstractRouterBuilderImpl;
import in.erail.service.RESTService;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.eventbus.Message;
import io.vertx.reactivex.core.http.HttpServerResponse;
import io.vertx.reactivex.ext.web.Cookie;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class OpenAPI3RouteBuilder
extends AbstractRouterBuilderImpl {
    private static final String HEADER_X_REQUEST_ID = "X-Request-ID";
    private static final String FAIL_SUFFIX = ".fail";
    private RESTService[] mServices;
    private File mOpenAPI3File;
    private DeliveryOptions mDeliveryOptions;
    private boolean mSecurityEnable = true;
    private HashMap<String, Metered> mMetrics = new HashMap();
    private MetricRegistry mMetricRegistry;
    private String mRequestIdHeaderName = "X-Request-ID";

    public File getOpenAPI3File() {
        return this.mOpenAPI3File;
    }

    public void setOpenAPI3File(File pOpenAPI3File) {
        this.mOpenAPI3File = pOpenAPI3File;
    }

    public RESTService[] getServices() {
        return this.mServices;
    }

    public void setServices(RESTService[] pServices) {
        this.mServices = pServices;
    }

    @StartService
    public void start() {
        Arrays.stream(this.getServices()).forEach(service -> {
            this.getMetrics().put(service.getServiceUniqueId(), (Metered)this.getMetricRegistry().timer("api.framework.service." + service.getServiceUniqueId()));
            this.getMetrics().put(service.getServiceUniqueId() + FAIL_SUFFIX, (Metered)this.getMetricRegistry().meter("api.framework.service." + service.getServiceUniqueId() + FAIL_SUFFIX));
        });
    }

    public void process(RoutingContext pRequestContext, String pServiceUniqueId) {
        Timer.Context timerCtx = ((Timer)this.getMetrics().get(pServiceUniqueId)).time();
        String requestId = pRequestContext.request().getHeader(this.getRequestIdHeaderName());
        if (Strings.isNullOrEmpty((String)requestId)) {
            requestId = UUID.randomUUID().toString();
            pRequestContext.request().headers().add(this.getRequestIdHeaderName(), UUID.randomUUID().toString());
        }
        pRequestContext.response().putHeader(this.getRequestIdHeaderName(), requestId);
        this.getVertx().eventBus().send(pServiceUniqueId, (Object)this.serialiseRoutingContext(pRequestContext), this.getDeliveryOptions(), reply -> {
            if (reply.succeeded()) {
                JsonObject response = (JsonObject)((Message)reply.result()).body();
                HttpServerResponse resp = this.buildResponseFromReply(response, pRequestContext);
                resp.end();
            } else {
                ((Meter)this.getMetrics().get(pServiceUniqueId + FAIL_SUFFIX)).mark();
                this.getLog().error(() -> "Error in reply:" + reply.cause().toString());
                pRequestContext.response().setStatusCode(400).end(reply.cause().toString());
            }
            timerCtx.stop();
        });
    }

    public JsonObject serialiseRoutingContext(RoutingContext pContext) {
        RequestEvent request = new RequestEvent();
        request.setHttpMethod(pContext.request().method());
        if (request.getHttpMethod() == HttpMethod.POST || request.getHttpMethod() == HttpMethod.PUT || request.getHttpMethod() == HttpMethod.PATCH) {
            request.setBody(pContext.getBody().getDelegate().getBytes());
        }
        request.setHeaders(this.convertMultiMapIntoMap(pContext.request().headers()));
        request.setQueryStringParameters(this.convertMultiMapIntoMap(pContext.queryParams()));
        request.setPathParameters(this.convertMultiMapIntoMap(pContext.request().params()));
        JsonObject principal = Optional.ofNullable(pContext.user()).flatMap(t -> Optional.ofNullable(t.principal())).orElse(new JsonObject());
        request.setPrincipal(principal.getMap());
        JsonObject result = JsonObject.mapFrom((Object)request);
        this.getLog().debug(() -> "Context to JSON:" + result.toString());
        return result;
    }

    public HttpServerResponse buildResponseFromReply(JsonObject pReplyResponse, RoutingContext pContext) {
        ResponseEvent response = (ResponseEvent)pReplyResponse.mapTo(ResponseEvent.class);
        Optional<String> contentType = Optional.ofNullable(response.headerValue("Content-Type"));
        if (!contentType.isPresent()) {
            response.setMediaType(MediaType.OCTET_STREAM);
        }
        response.getHeaders().entrySet().stream().forEach(kv -> pContext.response().putHeader((String)kv.getKey(), (String)kv.getValue()));
        pContext.response().setStatusCode(response.getStatusCode());
        Map[] cookies = Optional.ofNullable(response.getCookies()).orElse(new Map[0]);
        Arrays.stream(cookies).map(t -> {
            Optional cookieName = Optional.ofNullable(t.get("name"));
            if (cookieName.isPresent()) {
                Cookie c = Cookie.cookie((String)((String)cookieName.get()), (String)"");
                Optional.ofNullable(t.get("value")).ifPresent(v -> c.setValue(v));
                Optional.ofNullable(t.get("path")).ifPresent(v -> c.setPath(v));
                Optional.ofNullable(t.get("maxAge")).ifPresent(v -> c.setMaxAge(Long.parseLong(v)));
                Optional.ofNullable(t.get("domain")).ifPresent(v -> c.setDomain(v));
                Optional.ofNullable(t.get("secure")).ifPresent(v -> c.setSecure(Boolean.parseBoolean(v)));
                Optional.ofNullable(t.get("httpOnly")).ifPresent(v -> c.setHttpOnly(Boolean.parseBoolean(v)));
                return Optional.of(c);
            }
            return Optional.empty();
        }).filter(t -> t.isPresent()).forEach(t -> pContext.addCookie((Cookie)t.get()));
        Optional<byte[]> body = Optional.ofNullable(response.getBody());
        body.ifPresent(t -> {
            pContext.response().putHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), Integer.toString(((byte[])t).length));
            pContext.response().write(Buffer.buffer((byte[])t));
        });
        return pContext.response();
    }

    public Map<String, String> convertMultiMapIntoMap(MultiMap pMultiMap) {
        return pMultiMap.getDelegate().entries().stream().collect(Collectors.toMap(t -> (String)t.getKey(), t -> (String)t.getValue(), (a, b) -> a));
    }

    public DeliveryOptions getDeliveryOptions() {
        return this.mDeliveryOptions;
    }

    public void setDeliveryOptions(DeliveryOptions pDeliveryOptions) {
        this.mDeliveryOptions = pDeliveryOptions;
    }

    @Override
    public Router getRouter(Router pRouter) {
        OpenAPI3RouterFactory apiFactory = (OpenAPI3RouterFactory)OpenAPI3RouterFactory.rxCreate((Vertx)this.getVertx(), (String)this.getOpenAPI3File().getAbsolutePath()).blockingGet();
        Optional.ofNullable(this.getServices()).ifPresent(t -> Arrays.asList(t).stream().forEach(service -> {
            this.getLog().debug(() -> "Adding OpenAPI service handle:" + service.getOperationId());
            apiFactory.addHandlerByOperationId(service.getOperationId(), routingContext -> {
                if (this.isSecurityEnable() && service.isSecure()) {
                    if (routingContext.user() == null) {
                        routingContext.fail(401);
                        return;
                    }
                    Optional<String[]> authorities = Optional.ofNullable(service.getAuthority());
                    if (authorities.isPresent()) {
                        Observable.fromArray((Object[])authorities.get()).flatMapSingle(a -> routingContext.user().rxIsAuthorized(a)).filter(a -> a).firstElement().subscribe(success -> {
                            this.getLog().trace(() -> "Request is authorized. Processing Message:" + service.getOperationId());
                            this.process((RoutingContext)routingContext, service.getServiceUniqueId());
                        }, err -> {
                            this.getLog().error(() -> "Error processing serive message", err);
                            routingContext.fail(err);
                        }, () -> {
                            this.getLog().warn(() -> "You are not authorized to access service:" + service.getOperationId() + ":" + routingContext.toString());
                            routingContext.fail(401);
                        });
                    } else {
                        this.getLog().error(() -> "Service marked as secure, but, no authority defined at service level:" + service.getOperationId());
                        routingContext.fail(401);
                    }
                } else {
                    this.getLog().warn("Security disabled for " + service.getServiceUniqueId());
                    this.process((RoutingContext)routingContext, service.getServiceUniqueId());
                }
            });
            apiFactory.addFailureHandlerByOperationId(service.getOperationId(), routingContext -> {
                int respStatusCode = routingContext.statusCode();
                if (respStatusCode == -1) {
                    respStatusCode = 400;
                }
                this.getLog().debug(() -> "API Failure Handle called:" + service.getOperationId() + ":" + this.generateErrorResponse((RoutingContext)routingContext));
                routingContext.response().setStatusCode(respStatusCode).end(this.generateErrorResponse((RoutingContext)routingContext));
            });
            apiFactory.setValidationFailureHandler(routingContext -> {
                int respStatusCode = routingContext.statusCode();
                if (respStatusCode == -1) {
                    respStatusCode = 400;
                }
                this.getLog().debug(() -> "API Validation Failer Handle called:" + service.getOperationId() + ":" + this.generateErrorResponse((RoutingContext)routingContext));
                routingContext.response().setStatusCode(respStatusCode).end(this.generateErrorResponse((RoutingContext)routingContext));
            });
            apiFactory.setNotImplementedFailureHandler(routingContext -> {
                this.getLog().debug(() -> "API not implemented:" + service.getOperationId() + ":" + this.generateErrorResponse((RoutingContext)routingContext));
                routingContext.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(this.generateErrorResponse((RoutingContext)routingContext));
            });
        }));
        return apiFactory.getRouter();
    }

    protected String generateErrorResponse(RoutingContext pContext) {
        return Optional.ofNullable(pContext.failure()).map(error -> ExceptionUtils.getMessage((Throwable)error)).orElse(pContext.getBodyAsString());
    }

    public boolean isSecurityEnable() {
        return this.mSecurityEnable;
    }

    public void setSecurityEnable(boolean pSecurityEnable) {
        this.mSecurityEnable = pSecurityEnable;
    }

    public void setOpenAPI3JSON(JsonObject pOpenAPI3JSON) {
        try {
            File f = File.createTempFile("openapi3json", null);
            this.getVertx().getDelegate().fileSystem().writeFileBlocking(f.getAbsolutePath(), pOpenAPI3JSON.toBuffer());
            this.setOpenAPI3File(f);
        }
        catch (IOException ex) {
            this.getLog().error((Object)ex);
        }
    }

    public HashMap<String, Metered> getMetrics() {
        return this.mMetrics;
    }

    public void setMetrics(HashMap<String, Metered> pMetrics) {
        this.mMetrics = pMetrics;
    }

    public MetricRegistry getMetricRegistry() {
        return this.mMetricRegistry;
    }

    public void setMetricRegistry(MetricRegistry pMetricRegistry) {
        this.mMetricRegistry = pMetricRegistry;
    }

    public String getRequestIdHeaderName() {
        return this.mRequestIdHeaderName;
    }

    public void setRequestIdHeaderName(String pRequestIdHeaderName) {
        this.mRequestIdHeaderName = pRequestIdHeaderName;
    }
}

