/*
 * Decompiled with CFR 0.152.
 */
package in.erail.route;

import com.google.common.base.Strings;
import in.erail.route.AbstractRouterBuilderImpl;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.auth.AuthProvider;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.RoutingContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoadUserFromAccessTokenRouteBuillder
extends AbstractRouterBuilderImpl {
    private final Pattern AUTH_TOKEN = Pattern.compile("^Bearer\\s(?<token>.*)");
    private AuthProvider mAuthProvider;

    @Override
    public Router getRouter(Router pRouter) {
        pRouter.route().handler(this::handle);
        return pRouter;
    }

    public void handle(RoutingContext pRoutingContext) {
        String access_token;
        if (pRoutingContext.user() == null && !Strings.isNullOrEmpty((String)(access_token = pRoutingContext.request().getHeader("Authorization")))) {
            Matcher tokenRegex = this.AUTH_TOKEN.matcher(access_token);
            if (tokenRegex.find()) {
                String token = tokenRegex.group("token");
                JsonObject authInfo = new JsonObject().put("access_token", token).put("token_type", "Bearer").put("jwt", token);
                try {
                    pRoutingContext.setUser((User)this.getAuthProvider().rxAuthenticate(authInfo).blockingGet());
                }
                catch (RuntimeException e) {
                    this.getLog().error((Object)e);
                    pRoutingContext.fail(401);
                    return;
                }
            } else {
                this.getLog().warn(() -> "Invalid Auth Header:" + access_token);
            }
        }
        pRoutingContext.next();
    }

    public AuthProvider getAuthProvider() {
        return this.mAuthProvider;
    }

    public void setAuthProvider(AuthProvider pAuthProvider) {
        this.mAuthProvider = pAuthProvider;
    }
}

