/*
 * Decompiled with CFR 0.152.
 */
package in.erail.model;

import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.MultiMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ResponseEvent {
    private Map<String, String>[] mCookies;
    private boolean mIsBase64Encoded = true;
    private int mStatusCode = 200;
    private MultiMap mMultiValueHeaders;
    private byte[] mBody = new byte[0];

    public ResponseEvent() {
        this.mMultiValueHeaders = MultiMap.caseInsensitiveMultiMap();
    }

    public boolean isIsBase64Encoded() {
        return this.mIsBase64Encoded;
    }

    public ResponseEvent setIsBase64Encoded(boolean pIsBase64Encoded) {
        this.mIsBase64Encoded = pIsBase64Encoded;
        return this;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public ResponseEvent setStatusCode(int pStatusCode) {
        this.mStatusCode = pStatusCode;
        return this;
    }

    public byte[] getBody() {
        return this.mBody;
    }

    public ResponseEvent setBody(byte[] pBody) {
        this.mBody = pBody;
        return this;
    }

    public Map<String, String>[] getCookies() {
        return this.mCookies;
    }

    public ResponseEvent setCookies(Map<String, String>[] pCookies) {
        this.mCookies = pCookies;
        return this;
    }

    public ResponseEvent setMultiValueHeaders(Map<String, String[]> pValue) {
        Preconditions.checkNotNull(pValue);
        if (pValue.isEmpty()) {
            return this;
        }
        this.mMultiValueHeaders = pValue.entrySet().stream().reduce(MultiMap.caseInsensitiveMultiMap(), (a, v) -> {
            Optional.ofNullable(v.getValue()).map(t -> Arrays.stream(t)).orElse(Arrays.stream(new String[0])).forEach(t -> a.add((String)v.getKey(), t));
            return a;
        }, (a, b) -> {
            a.addAll(b);
            return a;
        });
        return this;
    }

    public Map<String, String[]> getMultiValueHeaders() {
        Map result = this.mMultiValueHeaders.names().stream().reduce(new HashMap(), (a, v) -> {
            a.put(v, this.mMultiValueHeaders.getAll(v).toArray(new String[0]));
            return a;
        }, (a, b) -> {
            a.putAll(b);
            return a;
        });
        return Collections.unmodifiableMap(result);
    }

    public ResponseEvent setHeaders(Map<String, String> pValue) {
        Preconditions.checkNotNull(pValue);
        if (pValue.isEmpty()) {
            return this;
        }
        this.mMultiValueHeaders = pValue.entrySet().stream().reduce(MultiMap.caseInsensitiveMultiMap(), (a, v) -> {
            Optional.ofNullable(v.getValue()).ifPresent(t -> a.add((String)v.getKey(), t));
            return a;
        }, (a, b) -> {
            a.addAll(b);
            return a;
        });
        return this;
    }

    public Map<String, String> getHeaders() {
        Map result = this.mMultiValueHeaders.names().stream().reduce(new HashMap(), (a, v) -> {
            a.put(v, this.mMultiValueHeaders.get(v));
            return a;
        }, (a, b) -> {
            a.putAll(b);
            return a;
        });
        return Collections.unmodifiableMap(result);
    }

    public ResponseEvent setContentType(String pContentType) {
        if (this.mMultiValueHeaders.contains("Content-Type")) {
            this.mMultiValueHeaders.remove("Content-Type");
        }
        this.mMultiValueHeaders.add("Content-Type", pContentType);
        return this;
    }

    public ResponseEvent setMediaType(MediaType pMediaType) {
        this.setContentType(pMediaType.toString());
        return this;
    }

    public ResponseEvent addHeader(String pHeaderName, String pValue) {
        this.mMultiValueHeaders.add(pHeaderName, pValue);
        return this;
    }

    public String headerValue(String pHeaderName) {
        return this.mMultiValueHeaders.get(pHeaderName);
    }

    public String toString() {
        return JsonObject.mapFrom((Object)this).toString();
    }
}

