/*
 * Decompiled with CFR 0.152.
 */
package in.erail.route;

import in.erail.route.AbstractRouterBuilderImpl;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.ext.auth.oauth2.AccessToken;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.reactivex.ext.web.Session;

public class LoadUserFromSessionRouteBuillder
extends AbstractRouterBuilderImpl {
    private OAuth2Auth mOAuth2Auth;

    public OAuth2Auth getOAuth2Auth() {
        return this.mOAuth2Auth;
    }

    public void setOAuth2Auth(OAuth2Auth pOAuth2Auth) {
        this.mOAuth2Auth = pOAuth2Auth;
    }

    @Override
    public Router getRouter(Router pRouter) {
        pRouter.route().handler(this::handle);
        return pRouter;
    }

    public void handle(RoutingContext pRoutingContext) {
        JsonObject principal;
        Session session = pRoutingContext.session();
        if (session != null && this.getOAuth2Auth() != null && (principal = (JsonObject)session.get("user")) != null) {
            OAuth2AuthProviderImpl provider = (OAuth2AuthProviderImpl)this.getOAuth2Auth().getDelegate();
            try {
                OAuth2TokenImpl token = new OAuth2TokenImpl((io.vertx.ext.auth.oauth2.OAuth2Auth)provider, principal);
                pRoutingContext.setUser((User)new AccessToken((io.vertx.ext.auth.oauth2.AccessToken)token));
            }
            catch (RuntimeException e) {
                this.getLog().error((Object)e);
                pRoutingContext.fail(401);
                return;
            }
        }
        pRoutingContext.next();
    }
}

