/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler.sockjs.processor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import in.erail.glue.annotation.StartService;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.Refill;
import io.github.bucket4j.local.LocalBucketBuilder;
import io.reactivex.Single;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEventContext;
import io.vertx.reactivex.ext.web.handler.sockjs.processor.BridgeEventProcessor;
import java.time.Duration;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class RateLimiterProcessor
implements BridgeEventProcessor {
    private final Map<BridgeEventType, Cache<String, Bucket>> mCache = new EnumMap<BridgeEventType, Cache<String, Bucket>>(BridgeEventType.class);
    private final Map<BridgeEventType, Integer> mTokenBucketSize = new EnumMap<BridgeEventType, Integer>(BridgeEventType.class);
    private final Map<BridgeEventType, Integer> mRateOfTokenFill = new EnumMap<BridgeEventType, Integer>(BridgeEventType.class);
    private final Map<BridgeEventType, Integer> mRateOfTokenFillDuration = new EnumMap<BridgeEventType, Integer>(BridgeEventType.class);
    private int mDefaultTokenBucketSize = 120;
    private int mDefaultRateOfTokenFill = 1;
    private int mDefaultRateOfTokenFillDuration = 1;
    private int mMaximumSize = 50000;
    private int mExpireAfterAccess = 3600;
    private boolean mEnable = true;
    private boolean mWarningOnly = true;
    private Logger mLog;

    @StartService
    public void start() {
        for (BridgeEventType type : BridgeEventType.values()) {
            Cache cache = CacheBuilder.newBuilder().recordStats().expireAfterAccess((long)this.getExpireAfterAccess(), TimeUnit.SECONDS).maximumSize((long)this.getMaximumSize()).build();
            this.getCache().put(type, (Cache<String, Bucket>)cache);
        }
    }

    @Override
    public Single<BridgeEventContext> process(Single<BridgeEventContext> pContext) {
        return pContext.map(ctx -> {
            if (ctx.getBridgeEvent().failed() || !this.isEnable()) {
                return ctx;
            }
            BridgeEventType eventType = ctx.getBridgeEvent().type();
            Bucket bucket = (Bucket)this.getCache().get(eventType).get((Object)ctx.getBridgeEvent().socket().writeHandlerID(), () -> {
                Refill refill = Refill.smooth((long)this.getRateOfTokenFill().getOrDefault(eventType, this.getDefaultRateOfTokenFill()).intValue(), (Duration)Duration.ofSeconds(this.getRateOfTokenFillDuration().getOrDefault(eventType, this.getDefaultRateOfTokenFillDuration()).intValue()));
                Bandwidth limit = Bandwidth.classic((long)this.getTokenBucketSize().getOrDefault(eventType, this.getDefaultTokenBucketSize()).intValue(), (Refill)refill);
                return ((LocalBucketBuilder)Bucket4j.builder().addLimit(limit)).build();
            });
            if (!bucket.tryConsume(1L)) {
                if (!this.isWarningOnly()) {
                    ctx.getBridgeEvent().fail("Rate Limit Crossed");
                }
                this.getLog().warn(() -> String.format("[%s] Rate limit crossed for connection:[%s],event:[%s]", ctx.getId(), ctx.getBridgeEvent().socket().writeHandlerID(), eventType.toString()));
            }
            return ctx;
        });
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public int getMaximumSize() {
        return this.mMaximumSize;
    }

    public void setMaximumSize(int pMaximumSize) {
        this.mMaximumSize = pMaximumSize;
    }

    public int getExpireAfterAccess() {
        return this.mExpireAfterAccess;
    }

    public void setExpireAfterAccess(int pExpireAfterAccess) {
        this.mExpireAfterAccess = pExpireAfterAccess;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean pEnable) {
        this.mEnable = pEnable;
    }

    public Map<BridgeEventType, Cache<String, Bucket>> getCache() {
        return this.mCache;
    }

    public Map<BridgeEventType, Integer> getTokenBucketSize() {
        return this.mTokenBucketSize;
    }

    public Map<BridgeEventType, Integer> getRateOfTokenFill() {
        return this.mRateOfTokenFill;
    }

    public Map<BridgeEventType, Integer> getRateOfTokenFillDuration() {
        return this.mRateOfTokenFillDuration;
    }

    public void setTokenBucketSize(Map<String, String> pTokenBucketSize) {
        for (BridgeEventType type : BridgeEventType.values()) {
            if (pTokenBucketSize.containsKey(type.toString())) {
                String value = pTokenBucketSize.get(type.toString());
                this.mTokenBucketSize.put(type, Integer.parseInt(value));
                continue;
            }
            this.mTokenBucketSize.put(type, this.getDefaultTokenBucketSize());
        }
    }

    public void setRateOfTokenFill(Map<String, String> pRateOfTokenFill) {
        for (BridgeEventType type : BridgeEventType.values()) {
            if (pRateOfTokenFill.containsKey(type.toString())) {
                String value = pRateOfTokenFill.get(type.toString());
                this.mRateOfTokenFill.put(type, Integer.parseInt(value));
                continue;
            }
            this.mRateOfTokenFill.put(type, this.getDefaultRateOfTokenFill());
        }
    }

    public void setRateOfTokenFillDuration(Map<String, String> pRateOfTokenFillDuration) {
        for (BridgeEventType type : BridgeEventType.values()) {
            if (pRateOfTokenFillDuration.containsKey(type.toString())) {
                String value = pRateOfTokenFillDuration.get(type.toString());
                this.mRateOfTokenFillDuration.put(type, Integer.parseInt(value));
                continue;
            }
            this.mRateOfTokenFillDuration.put(type, this.getDefaultRateOfTokenFillDuration());
        }
    }

    public int getDefaultTokenBucketSize() {
        return this.mDefaultTokenBucketSize;
    }

    public void setDefaultTokenBucketSize(int pDefaultTokenBucketSize) {
        this.mDefaultTokenBucketSize = pDefaultTokenBucketSize;
    }

    public int getDefaultRateOfTokenFill() {
        return this.mDefaultRateOfTokenFill;
    }

    public void setDefaultRateOfTokenFill(int pDefaultRateOfTokenFill) {
        this.mDefaultRateOfTokenFill = pDefaultRateOfTokenFill;
    }

    public int getDefaultRateOfTokenFillDuration() {
        return this.mDefaultRateOfTokenFillDuration;
    }

    public void setDefaultRateOfTokenFillDuration(int pDefaultRateOfTokenFillDuration) {
        this.mDefaultRateOfTokenFillDuration = pDefaultRateOfTokenFillDuration;
    }

    public boolean isWarningOnly() {
        return this.mWarningOnly;
    }

    public void setWarningOnly(boolean pWarningOnly) {
        this.mWarningOnly = pWarningOnly;
    }
}

