/*
 * Decompiled with CFR 0.152.
 */
package in.erail.route;

import com.google.common.base.Strings;
import in.erail.route.AbstractRouterBuilderImpl;
import io.netty.handler.codec.http.HttpScheme;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.reactivex.ext.web.Session;

public class OIDCCallbackRouteBuilder
extends AbstractRouterBuilderImpl {
    private String mCallbackURI;
    private OAuth2Auth mOAuth2Auth;
    private String mQueryParamAuthCode;
    private boolean mEnableProxy;
    private String mSuccessPath;
    private String mFailPath;

    public void handle(RoutingContext pRoutingCoutext) {
        JsonObject tokenConfig = this.getTokenConfig(pRoutingCoutext);
        this.getOAuth2Auth().getDelegate().authenticate(tokenConfig, response -> {
            if (response.succeeded()) {
                Session session = pRoutingCoutext.session().regenerateId();
                session.put("user", (Object)((User)response.result()).principal());
                this.getLog().debug(() -> "Success URL:" + this.getSuccessURL(pRoutingCoutext));
                pRoutingCoutext.response().putHeader("Location", this.getSuccessURL(pRoutingCoutext)).setStatusCode(302).end();
            } else {
                this.getLog().error((Object)response.cause());
                this.getLog().debug(() -> "Fail URL:" + this.getFailURL(pRoutingCoutext));
                pRoutingCoutext.response().putHeader("Location", this.getFailURL(pRoutingCoutext)).setStatusCode(302).end();
            }
        });
    }

    private String baseURL(RoutingContext pRoutingContext) {
        String protocol;
        String host;
        if (this.isEnableProxy()) {
            host = pRoutingContext.request().getHeader("X-Forwarded-Host");
            protocol = pRoutingContext.request().getHeader("X-Forwarded-Proto");
        } else {
            host = pRoutingContext.request().getHeader("Host");
            protocol = HttpScheme.HTTP.name().toString();
        }
        String url = protocol + "://" + host;
        return url;
    }

    private String getSuccessURL(RoutingContext pRoutingContext) {
        StringBuffer url = new StringBuffer();
        url.append(url);
        if (!Strings.isNullOrEmpty((String)this.getSuccessPath())) {
            if (!this.getSuccessPath().startsWith("/")) {
                url.append("/");
            }
            url.append(this.getSuccessPath());
        }
        url.append("?login=success");
        return url.toString();
    }

    private String getFailURL(RoutingContext pRoutingContext) {
        StringBuffer url = new StringBuffer();
        url.append(url);
        if (!Strings.isNullOrEmpty((String)this.getFailPath())) {
            if (!this.getFailPath().startsWith("/")) {
                url.append("/");
            }
            url.append(this.getFailPath());
        }
        url.append("?login=fail");
        return url.toString();
    }

    private JsonObject getTokenConfig(RoutingContext pRoutingContext) {
        String authCode = pRoutingContext.request().params().get(this.getQueryParamAuthCode());
        return new JsonObject().put("code", authCode).put("redirect_uri", this.baseURL(pRoutingContext) + this.getCallbackURI());
    }

    public OAuth2Auth getOAuth2Auth() {
        return this.mOAuth2Auth;
    }

    public void setOAuth2Auth(OAuth2Auth pOAuth2Auth) {
        this.mOAuth2Auth = pOAuth2Auth;
    }

    public String getQueryParamAuthCode() {
        return this.mQueryParamAuthCode;
    }

    public void setQueryParamAuthCode(String pQueryParamAuthCode) {
        this.mQueryParamAuthCode = pQueryParamAuthCode;
    }

    public String getCallbackURI() {
        return this.mCallbackURI;
    }

    public void setCallbackURI(String pCallbackURI) {
        this.mCallbackURI = pCallbackURI;
    }

    @Override
    public Router getRouter(Router pRouter) {
        pRouter.route(this.getCallbackURI()).handler(this::handle);
        return pRouter;
    }

    public boolean isEnableProxy() {
        return this.mEnableProxy;
    }

    public void setEnableProxy(boolean pEnableProxy) {
        this.mEnableProxy = pEnableProxy;
    }

    public String getSuccessPath() {
        return this.mSuccessPath;
    }

    public void setSuccessPath(String pSuccessPath) {
        this.mSuccessPath = pSuccessPath;
    }

    public String getFailPath() {
        return this.mFailPath;
    }

    public void setFailPath(String pFailPath) {
        this.mFailPath = pFailPath;
    }
}

